<?php

declare(strict_types=1);

namespace idoit\Module\SyneticsFlows\Helper;

use isys_module_jdisc;
use isys_module_manager;
use isys_module_synetics_jdisc;

class JDiscHelper
{
    /**
     * Helper method to fetch the proper JDisc class.
     *
     * @return string|null
     * @see FLOW-418
     */
    public static function getClassName(): ?string
    {
        if (class_exists('isys_module_jdisc') && isys_module_manager::instance()->is_active('jdisc')) {
            return isys_module_jdisc::class;
        }

        if (class_exists('isys_module_synetics_jdisc') && isys_module_manager::instance()->is_active('synetics_jdisc')) {
            return isys_module_synetics_jdisc::class;
        }

        return null;
    }

    public static function getImportCommandNames(): array
    {
        if (self::getClassName() === null) {
            return [];
        }

        return [
            'jdisc:import',
            'import-jdisc', // Old command mane / alias.
        ];
    }

    public static function getDiscoveryCommandNames(): array
    {
        if (self::getClassName() === null) {
            return [];
        }

        return [
            'jdisc:discovery',
            'import-jdiscdiscovery', // Old command mane / alias.
        ];
    }
}
