<?php

namespace idoit\Module\SyneticsFlows\Model\AttributeDataExtractor;

use idoit\Component\Property\Property;
use idoit\Module\Cmdb\Component\AttributeDataCollector\CollectorTypes\AbstractCollector;

interface ExtractorInterface
{
    /**
     * @param AbstractCollector $dataCollector
     *
     * @return bool
     */
    public function supports(AbstractCollector $dataCollector): bool;

    /**
     * @param Property          $property
     * @param AbstractCollector $dataCollector
     * @param string|null       $entryId
     *
     * @return array
     */
    public function extract(Property $property, AbstractCollector $dataCollector, ?string $entryId = null): array;
}
