<?php

namespace idoit\Module\SyneticsFlows\Model\Dto;

use idoit\Module\SyneticsFlows\Serialization\Discriminator;
use idoit\Module\SyneticsFlows\Serialization\SerializableTrait;
use JsonSerializable;

#[Discriminator([
    'location' => LocationObjectAttributeData::class,
    'object' => ObjectAttributeData::class,
    'data' => AttributeData::class,
])]
class AttributeData implements JsonSerializable
{
    use SerializableTrait;

    public function __construct(
        protected string $id,
        protected string $title,
    )
    {
    }

    /**
     * @return string
     */
    public function getId(): string
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getTitle(): string
    {
        return $this->title;
    }

    public function __get($prop)
    {
        return $this->$prop;
    }

    public function __isset($prop): bool
    {
        return isset($this->$prop);
    }

    public function __toString(): string
    {
        return json_encode($this, null, 2);
    }
}
