<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Model\Dto;

use idoit\Module\SyneticsFlows\Serialization\SerializableTrait;
use JsonSerializable;

class ParentChildAttribute implements JsonSerializable
{
    use SerializableTrait;

    public function __construct(
        private ParentAttribute $parentAttribute,
        private array $children
    )
    {
    }

    public function getChildren(): array
    {
        return $this->children;
    }

    public function getParentAttribute(): ParentAttribute
    {
        return $this->parentAttribute;
    }
}
