<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Template;

use Twig\Environment;

class Template
{
    public function __construct(private Environment $twig)
    {
    }

    public function process(?string $template): ?string
    {
        if ($template === null) {
            return null;
        }
        $data = [];
        $twigTemplate = $this->twig->createTemplate($template);
        return $twigTemplate->render($data);
    }
}