<?php

class isys_auth_forms extends isys_auth implements isys_auth_interface
{
    /**
     * Container for singleton instance
     *
     * @var  isys_auth_forms
     */
    private static $instance;

    /**
     * Method for returning the available auth-methods. This will be used for the GUI.
     *
     * @return  array
     * @throws Exception
     */
    public function get_auth_methods()
    {
        return [
            'forms' => [
                'title'   => 'LC__MODULE__FORMS__FORMS',
                'type'    => 'boolean',
                'rights'  => [isys_auth::VIEW, isys_auth::CREATE, isys_auth::EDIT, isys_auth::DELETE],
                'default' => [isys_auth::VIEW],
            ],
        ];
    }

    /**
     * Method for checking, if the user is allowed to process the forms.
     *
     * @param integer $right
     *
     * @return  boolean
     *
     * @throws  isys_exception_auth
     * @throws Exception
     */
    public function forms($right)
    {
        if (!$this->is_auth_active()) {
            return true;
        }

        return $this->generic_right(
            $right,
            'forms',
            self::EMPTY_ID_PARAM,
            new isys_exception_auth(isys_application::instance()->container->get('language')->get('You are not allowed to execute the forms.'))
        );
    }

    /**
     * Get ID of related module.
     *
     * @return  integer
     */
    public function get_module_id()
    {
        return C__MODULE__FORMS;
    }

    /**
     * Get title of related module.
     *
     * @return  string
     */
    public function get_module_title()
    {
        return 'LC__MODULE__FORMS';
    }

    /**
     * Retrieve singleton instance of authorization class.
     *
     * @return isys_auth_forms
     */
    public static function instance()
    {
        // If the DAO has not been loaded yet, we initialize it now.
        if (self::$m_dao === null) {
            self::$m_dao = new isys_auth_dao(isys_application::instance()->container->get('database'));
        }

        if (self::$instance === null) {
            self::$instance = new self;
        }

        return self::$instance;
    }
}