"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = async () => ({
    clearMocks: true,
    collectCoverageFrom: [
        './src/**',
        '!./src/main.ts',
        '!./src/console/**',
        '!./src/**/*.module.ts',
        '!./src/**/*.spec.ts',
        '!./src/**/*.schema.ts',
        '!./src/**/*.dto.ts',
        '!./src/**/*-auth.guards.ts',
        '!./src/**/*.strategy.ts',
        '!./src/**/constants.ts',
    ],
    coverageReporters: ['lcov'],
    coverageThreshold: {
        global: {
            branches: 80,
            functions: 90,
            lines: 90,
            statements: 90,
        },
    },
    roots: ['<rootDir>/src'],
    transform: {
        '^.+\\.jsx?$': 'babel-jest',
        '^.+\\.tsx?$': 'ts-jest',
    },
    testEnvironment: 'node',
    testMatch: ['**/__tests__/**/*.+(ts|tsx)', '**/?(*.)+(spec|test).+(ts|tsx)'],
    testPathIgnorePatterns: ['<rootDir>/node_modules/'],
});
//# sourceMappingURL=jest.config.js.map