"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Command = exports.isCommandInfo = void 0;
const console_interface_1 = require("./console.interface");
const isCommandInfo = (info) => typeof info === 'object' && info.hasOwnProperty('name') && info.hasOwnProperty('description');
exports.isCommandInfo = isCommandInfo;
const Command = (name, description, parameters) => (target) => {
    Reflect.defineMetadata(console_interface_1.ConsoleMetaKey, {
        name,
        description,
        parameters,
    }, target);
};
exports.Command = Command;
//# sourceMappingURL=console.decorator.js.map