"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConsoleService = void 0;
const common_1 = require("@nestjs/common");
const core_1 = require("@nestjs/core");
const console_interface_1 = require("./console.interface");
let ConsoleService = class ConsoleService {
    constructor(moduleRef) {
        this.moduleRef = moduleRef;
        this.commands = {};
        this.add = async (key, type) => {
            const command = await this.moduleRef.get(type, { strict: false });
            if ((0, console_interface_1.isCommand)(command)) {
                this.commands[key.name] = [key, command];
            }
        };
    }
    async execute(name) {
        if (!this.commands.hasOwnProperty(name)) {
            return 1;
        }
        const [, command] = this.commands[name];
        if (!(0, console_interface_1.isCommand)(command)) {
            return 1;
        }
        return command.execute();
    }
};
exports.ConsoleService = ConsoleService;
exports.ConsoleService = ConsoleService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [core_1.ModuleRef])
], ConsoleService);
//# sourceMappingURL=console.service.js.map