import { Model, PipelineStage } from 'mongoose';
import { FormAccessService } from '../forms/form-access.service';
import { CurrentInstance } from '../instance/currentInstance';
import { CreateFormDataDto } from './dto/create-form-data.dto';
import { UpdateFormDataDto } from './dto/update-form-data.dto';
import { FormData, FormDataDocument } from './schemas/form-data.schema';
import { FindFormDataDto } from './dto/find-form-data.dto';
import { SearchResult } from './schemas/SearchResult';
export declare class FormDataService {
    private formDataModel;
    private instance;
    private formExists;
    constructor(formDataModel: Model<FormDataDocument>, instance: CurrentInstance, formExists: FormAccessService);
    create(createFormDto: CreateFormDataDto): Promise<FormData>;
    getStages(): PipelineStage[];
    findAll(find: FindFormDataDto): Promise<SearchResult<FormData>>;
    findOne(id: string): Promise<FormData>;
    update(id: string, updateFormDto: UpdateFormDataDto): Promise<FormData>;
    remove(id: string): Promise<FormData>;
}
