"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FormDataService = void 0;
const common_1 = require("@nestjs/common");
const mongoose_1 = require("@nestjs/mongoose");
const mongoose_2 = require("mongoose");
const form_access_service_1 = require("../forms/form-access.service");
const currentInstance_1 = require("../instance/currentInstance");
const form_data_schema_1 = require("./schemas/form-data.schema");
let FormDataService = class FormDataService {
    constructor(formDataModel, instance, formExists) {
        this.formDataModel = formDataModel;
        this.instance = instance;
        this.formExists = formExists;
    }
    async create(createFormDto) {
        if (!(await this.formExists.hasAccess(createFormDto.form))) {
            throw new common_1.BadRequestException('Reference error', `Referenced form '${createFormDto.form}' does not exist.`);
        }
        return this.formDataModel.create(Object.assign(Object.assign({}, createFormDto), { created: new Date(), updated: new Date(), published: false }));
    }
    getStages() {
        return [
            {
                $lookup: {
                    from: 'forms',
                    localField: 'form',
                    foreignField: '_id',
                    as: 'forms',
                    pipeline: [
                        { $match: { instance: this.instance.getCurrentInstance() } },
                    ],
                },
            },
            {
                $match: {
                    forms: {
                        $size: 1,
                    },
                },
            },
            {
                $unset: 'forms',
            },
        ];
    }
    async findAll(find) {
        var _a, _b;
        const stages = this.getStages();
        const countResponse = (_b = (_a = (await this.formDataModel.aggregate([
            ...stages,
            { $count: 'count' },
        ]))) === null || _a === void 0 ? void 0 : _a[0]) === null || _b === void 0 ? void 0 : _b.count;
        const count = typeof countResponse === 'number' ? countResponse : 0;
        const results = find.limit > 0
            ? await this.formDataModel.aggregate([
                ...stages,
                { $sort: { [find.sorting || '_id']: 1 } },
                { $skip: find.offset },
                { $limit: find.limit },
            ])
            : [];
        return {
            offset: find.offset,
            count,
            results,
        };
    }
    findOne(id) {
        return this.formDataModel.findById(id).exec();
    }
    update(id, updateFormDto) {
        return this.formDataModel
            .findByIdAndUpdate(id, {
            data: updateFormDto.data,
            updated: new Date(),
        }, { new: true })
            .exec();
    }
    remove(id) {
        return this.formDataModel.findByIdAndDelete(id).exec();
    }
};
exports.FormDataService = FormDataService;
exports.FormDataService = FormDataService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, mongoose_1.InjectModel)(form_data_schema_1.FormData.name)),
    __metadata("design:paramtypes", [mongoose_2.Model,
        currentInstance_1.CurrentInstance,
        form_access_service_1.FormAccessService])
], FormDataService);
//# sourceMappingURL=form-data.service.js.map