"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FormsController = void 0;
const common_1 = require("@nestjs/common");
const ObjectIdPipe_1 = require("../utils/ObjectIdPipe");
const forms_service_1 = require("./forms.service");
const create_form_dto_1 = require("./dto/create-form.dto");
const update_form_dto_1 = require("./dto/update-form.dto");
const find_form_dto_1 = require("./dto/find-form.dto");
const form_access_service_1 = require("./form-access.service");
const form_access_denied_exception_1 = require("./exception/form-access-denied.exception");
let FormsController = class FormsController {
    constructor(formsService, formAccess) {
        this.formsService = formsService;
        this.formAccess = formAccess;
    }
    async checkAccess(id) {
        if (!(await this.formAccess.hasAccess(id))) {
            throw new form_access_denied_exception_1.FormAccessDeniedException(id);
        }
    }
    create(createFormDto) {
        return this.formsService.create(createFormDto);
    }
    findAll(find) {
        return this.formsService.findAll(find);
    }
    async findOne(id) {
        await this.checkAccess(id);
        return this.formsService.findOne(id);
    }
    async findOneByIdentifier(identifier) {
        const form = await this.formsService.findByIdentifier(identifier);
        await this.checkAccess(form.id);
        return form;
    }
    async update(id, updateFormDto) {
        await this.checkAccess(id);
        return this.formsService.update(id, updateFormDto);
    }
    async remove(id) {
        await this.checkAccess(id);
        return this.formsService.remove(id);
    }
};
exports.FormsController = FormsController;
__decorate([
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_form_dto_1.CreateFormDto]),
    __metadata("design:returntype", Promise)
], FormsController.prototype, "create", null);
__decorate([
    (0, common_1.Get)(),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [find_form_dto_1.FindFormDto]),
    __metadata("design:returntype", Promise)
], FormsController.prototype, "findAll", null);
__decorate([
    (0, common_1.Get)(':id'),
    __param(0, (0, common_1.Param)('id', ObjectIdPipe_1.ObjectIdPipe)),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], FormsController.prototype, "findOne", null);
__decorate([
    (0, common_1.Get)('id/:identifier'),
    __param(0, (0, common_1.Param)('identifier')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], FormsController.prototype, "findOneByIdentifier", null);
__decorate([
    (0, common_1.Patch)(':id'),
    __param(0, (0, common_1.Param)('id', ObjectIdPipe_1.ObjectIdPipe)),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, update_form_dto_1.UpdateFormDto]),
    __metadata("design:returntype", Promise)
], FormsController.prototype, "update", null);
__decorate([
    (0, common_1.Delete)(':id'),
    __param(0, (0, common_1.Param)('id', ObjectIdPipe_1.ObjectIdPipe)),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], FormsController.prototype, "remove", null);
exports.FormsController = FormsController = __decorate([
    (0, common_1.Controller)('api/form'),
    __metadata("design:paramtypes", [forms_service_1.FormsService, form_access_service_1.FormAccessService])
], FormsController);
//# sourceMappingURL=forms.controller.js.map