"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ObjectIdPipe = void 0;
const common_1 = require("@nestjs/common");
const mongoose_1 = require("mongoose");
let ObjectIdPipe = class ObjectIdPipe {
    transform(value) {
        if (typeof value !== 'string') {
            throw new common_1.BadRequestException('Asset id needs to be a string');
        }
        if (!mongoose_1.Types.ObjectId.isValid(value)) {
            throw new common_1.BadRequestException(`'${value}' is not a valid asset id`);
        }
        return value;
    }
};
exports.ObjectIdPipe = ObjectIdPipe;
exports.ObjectIdPipe = ObjectIdPipe = __decorate([
    (0, common_1.Injectable)()
], ObjectIdPipe);
//# sourceMappingURL=ObjectIdPipe.js.map