#!/bin/sh
cd "$(dirname "$0")"
IDOIT_FORMS_UNIT="i-doit-forms"
IDOIT_FORMS_DIR=$(pwd)
cat <<EOT >> "/lib/systemd/system/${IDOIT_FORMS_UNIT}.service"
[Unit]
Description=i-doit pro Forms add-on (backend part)

[Service]
Type=simple
User=www-data
Group=www-data
WorkingDirectory=${IDOIT_FORMS_DIR}
ExecStart=${IDOIT_FORMS_DIR}/run.sh
SyslogIdentifier=i-doit-forms
Restart=on-failure
RestartSec=10s

[Install]
WantedBy=multi-user.target
EOT
systemctl daemon-reload
systemctl enable "${IDOIT_FORMS_UNIT}"
systemctl start "${IDOIT_FORMS_UNIT}"
systemctl status "${IDOIT_FORMS_UNIT}"