<?php

namespace idoit\Module\Forms\Model;

use idoit\Model\Dao\Base;
use isys_component_dao_result;

class ClassDao extends Base
{
  /**
   * @return string[]
   */
  private function getBlockedClasses() {
    $blockedClasses = [
      'C__OBJTYPE__LAYER3_NET',
      'C__OBJTYPE__LAYER2_NET',
      'C__OBJTYPE__SUPERNET',
      'C__OBJTYPE__NET_ZONE',
      'C__OBJTYPE__WAN'
    ];

    return array_filter($blockedClasses, 'defined');
  }

  /**
   * @return string
   */
  private function getBlockedClassesCondition() {
    $blockedClasses = $this->getBlockedClasses();
    $blockedClassesCondition = '';

    if (!empty($blockedClasses)) {
      $blockedClassesCondition = sprintf('AND isys_obj_type__const NOT IN (%s)',
        implode(',', array_map([$this, 'convert_sql_text'], $blockedClasses)));
    }
    return $blockedClassesCondition;
  }

  /**
   * @return isys_component_dao_result
   * @throws \isys_exception_database
   */
  public function getAll(): isys_component_dao_result
  {
    $recordStatusNormal = $this->convert_sql_int(C__RECORD_STATUS__NORMAL);

    $sql = "SELECT isys_obj_type__const AS id, isys_obj_type__title AS title, isys_obj_type__icon AS icon
      FROM isys_obj_type
      INNER JOIN isys_obj_type_group ON isys_obj_type_group__id = isys_obj_type.isys_obj_type__isys_obj_type_group__id
      WHERE isys_obj_type__status = {$recordStatusNormal}
      AND isys_obj_type_group__status = {$recordStatusNormal}
      AND isys_obj_type__show_in_tree = 1 {$this->getBlockedClassesCondition()};";

    return $this->retrieve($sql);
  }
}
