<?php

namespace idoit\Module\Forms\Model\Validators\Category;

use idoit\Module\Forms\Model\Validators\GenericValidator;
use idoit\Module\Forms\Model\Validators\ValidatorInterface;
use isys_application;
use isys_cmdb_dao_category;

class DatabaseAssignmentValidator extends AbstractCategoryValidator implements ValidatorInterface
{
  public const CATEGORY_CONST = 'C__CATG__DATABASE_ASSIGNMENT';

  /**
   * @param array                  $formData
   * @param isys_cmdb_dao_category $categoryDao
   *
   * @return array|null
   * @throws \Exception
   */
  public function validate(array $formData, isys_cmdb_dao_category $categoryDao): ?array
  {
    $genericValidator = (GenericValidator::factory());
    $language = isys_application::instance()->container->get('language');
    $issues = [];

    if (array_key_exists('database_assignment', $formData)
      && empty($formData['database_assignment'])
    ) {
      $issues['database_assignment'] = $language
        ->get('LC__CMDB__OBJECT_BROWSER__PLEASE_MAKE_A_SELECTION');
    }

    if (array_key_exists('runs_on', $formData)
      && empty($p_data['runs_on'])
    ) {
      $issues['runs_on'] = $language
        ->get('LC__CMDB__OBJECT_BROWSER__PLEASE_MAKE_A_SELECTION');
    }

    unset($formData['database_assignment'], $formData['runs_on']);
    $generalIssues = $genericValidator->validate($formData, $categoryDao);

    if (is_array($generalIssues)) {
      $issues = array_merge($generalIssues, $issues);
    }

    return !empty($issues) ? $issues : null;
  }
}
