<?php

namespace idoit\Module\Forms\View;

use idoit\Model\Dao\Base as DaoBase;
use idoit\Module\Forms\Proxy\RequestProxy;
use idoit\View\ReactRenderable;
use idoit\View\Renderable;
use isys_application;
use isys_auth;
use isys_auth as Auth;
use isys_component_template as ComponentTemplate;
use isys_module as Module;
use isys_module_forms as ModuleForms;
use isys_register as Request;

class Main extends ReactRenderable
{
    public function __construct(Request $request, $component, $params) {
        parent::__construct($component, $params);
    }

    /**
     * @param Module            $module
     * @param ComponentTemplate $template
     * @param DaoBase           $model
     *
     * @return $this|Renderable
     * @throws \Exception
     */
    public function process(Module $module, ComponentTemplate $template, DaoBase $model)
    {
        $auth = ModuleForms::getAuth();
        $language = isys_application::instance()->container->get('language');
        $session = isys_application::instance()->container->get('session');
        $user = $session->get_userdata();

        $template
            ->assign('formsDocumentRoot', isys_application::instance()->www_path);

        // Check if the user is allowed to view the forms main view.
        if (!$auth->is_allowed_to(Auth::VIEW, 'forms')) {
            $template
                ->assign('errorMessage', $language->get('LC__MODULE__FORMS__AUTH__MISSING_FORMS_RIGHT', $language->get('LC__AUTH__RIGHT_VIEW')))
                ->include_template('contentbottomcontent', ModuleForms::getPath() . 'templates/error.tpl');

            return $this;
        }

        // Check if valid license is present
        if (!$module::is_licenced()) {
            $template
                ->assign('errorMessage', $language->get('LC__MODULE__FORMS__NOT_LICENSED'))
                ->include_template('contentbottomcontent', ModuleForms::getPath() . 'templates/error.tpl');

            return $this;
        }

        $proxy = new RequestProxy($session);
        try {
            $proxy->authorize();
        } catch (\Exception $e) {
            $template
                ->assign('errorMessage', $language->get('LC__MODULE__FORMS__AUTH__NOT_CONFIGURED'))
                ->include_template('contentbottomcontent', ModuleForms::getPath() . 'templates/error.tpl');

            return $this;
        }

        $template
            ->assign('reactComponent', $this->getComponent())
            ->assign('currentUser', $user)
            ->assign('formsAuth', [
                'create'  => $auth->is_allowed_to(isys_auth::CREATE, 'forms'),
                'view'    => $auth->is_allowed_to(isys_auth::VIEW, 'forms'),
                'edit'    => $auth->is_allowed_to(isys_auth::EDIT, 'forms'),
                'delete'  => $auth->is_allowed_to(isys_auth::DELETE, 'forms'),
                'execute' => $auth->is_allowed_to(isys_auth::EXECUTE, 'forms'),
            ])
            ->assign('reactParams', $this->getParams())
            ->include_template('contentbottomcontent', ModuleForms::getPath() . 'templates/main.tpl');

        return $this;
    }
}
