"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthService = void 0;
const common_1 = require("@nestjs/common");
const jwt_1 = require("@nestjs/jwt");
const instance_service_1 = require("../instance/instance.service");
let AuthService = class AuthService {
    constructor(instanceService, jwtService) {
        this.instanceService = instanceService;
        this.jwtService = jwtService;
    }
    async validateInstance(name, apikey) {
        const instance = await this.instanceService.findOneByNameAndKey(name, apikey);
        if (instance) {
            return instance;
        }
        return null;
    }
    async login(instance) {
        const payload = { _id: instance._id, name: instance.name, sub: instance.apikey };
        return {
            access_token: this.jwtService.sign(payload),
        };
    }
};
exports.AuthService = AuthService;
exports.AuthService = AuthService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [instance_service_1.InstanceService,
        jwt_1.JwtService])
], AuthService);
//# sourceMappingURL=auth.service.js.map