"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FormDataController = void 0;
const common_1 = require("@nestjs/common");
const ObjectIdPipe_1 = require("../utils/ObjectIdPipe");
const form_access_service_1 = require("../forms/form-access.service");
const form_data_service_1 = require("./form-data.service");
const create_form_data_dto_1 = require("./dto/create-form-data.dto");
const update_form_data_dto_1 = require("./dto/update-form-data.dto");
const find_form_data_dto_1 = require("./dto/find-form-data.dto");
const form_data_access_exception_1 = require("./exception/form-data-access.exception");
let FormDataController = class FormDataController {
    constructor(formsService, accessService) {
        this.formsService = formsService;
        this.accessService = accessService;
    }
    async checkAccess(id) {
        const formData = await this.formsService.findOne(id);
        if (!formData || !await this.accessService.hasAccess(formData.form)) {
            throw new form_data_access_exception_1.FormDataAccessException(id);
        }
    }
    create(createFormDto) {
        return this.formsService.create(createFormDto);
    }
    findAll(find) {
        return this.formsService.findAll(find);
    }
    async findOne(id) {
        await this.checkAccess(id);
        return this.formsService.findOne(id);
    }
    async update(id, updateFormDto) {
        await this.checkAccess(id);
        return this.formsService.update(id, updateFormDto);
    }
    async remove(id) {
        await this.checkAccess(id);
        return this.formsService.remove(id);
    }
};
exports.FormDataController = FormDataController;
__decorate([
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_form_data_dto_1.CreateFormDataDto]),
    __metadata("design:returntype", Promise)
], FormDataController.prototype, "create", null);
__decorate([
    (0, common_1.Get)(),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [find_form_data_dto_1.FindFormDataDto]),
    __metadata("design:returntype", Promise)
], FormDataController.prototype, "findAll", null);
__decorate([
    (0, common_1.Get)(':id'),
    __param(0, (0, common_1.Param)('id', ObjectIdPipe_1.ObjectIdPipe)),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], FormDataController.prototype, "findOne", null);
__decorate([
    (0, common_1.Patch)(':id'),
    __param(0, (0, common_1.Param)('id', ObjectIdPipe_1.ObjectIdPipe)),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, update_form_data_dto_1.UpdateFormDataDto]),
    __metadata("design:returntype", Promise)
], FormDataController.prototype, "update", null);
__decorate([
    (0, common_1.Delete)(':id'),
    __param(0, (0, common_1.Param)('id', ObjectIdPipe_1.ObjectIdPipe)),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], FormDataController.prototype, "remove", null);
exports.FormDataController = FormDataController = __decorate([
    (0, common_1.Controller)('api/form/data'),
    __metadata("design:paramtypes", [form_data_service_1.FormDataService,
        form_access_service_1.FormAccessService])
], FormDataController);
//# sourceMappingURL=form-data.controller.js.map