import { FormsService } from './forms.service';
import { CreateFormDto } from './dto/create-form.dto';
import { UpdateFormDto } from './dto/update-form.dto';
import { FindFormDto } from './dto/find-form.dto';
import { Form } from './schemas/form.schema';
import { SearchResult } from './schemas/SearchResult';
import { FormAccessService } from './form-access.service';
export declare class FormsController {
    private readonly formsService;
    private readonly formAccess;
    constructor(formsService: FormsService, formAccess: FormAccessService);
    checkAccess(id: string): Promise<void>;
    create(createFormDto: CreateFormDto): Promise<Form>;
    findAll(find: FindFormDto): Promise<SearchResult<Form>>;
    findOne(id: string): Promise<Form>;
    findOneByIdentifier(identifier: string): Promise<Form>;
    update(id: string, updateFormDto: UpdateFormDto): Promise<Form>;
    remove(id: string): Promise<Form>;
}
