"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RemoveInstanceCommand = void 0;
const common_1 = require("@nestjs/common");
const console_1 = require("../../console");
const instance_service_1 = require("../instance.service");
let RemoveInstanceCommand = class RemoveInstanceCommand extends console_1.CommandInterface {
    constructor(service) {
        super();
        this.service = service;
    }
    async execute() {
        const name = process.argv[3] || process.env.FORMS_ACCESS_USERNAME;
        const apikey = process.argv[4] || process.env.FORMS_ACCESS_PASSWORD;
        try {
            const formsInstance = await this.service.findOneByNameAndKey(name, apikey);
            await this.service.remove(formsInstance['_id']);
            this.log(`Instance ${name} with API Key *** has been successfully removed.`);
        }
        catch (e) {
            this.log(`A problem occurred while removing the instance. ${e}`);
        }
        return 0;
    }
};
exports.RemoveInstanceCommand = RemoveInstanceCommand;
exports.RemoveInstanceCommand = RemoveInstanceCommand = __decorate([
    (0, common_1.Injectable)(),
    (0, console_1.Command)('instance:remove', 'Removes an instance', [
        {
            name: 'username',
            description: 'User name for the instance'
        },
        {
            name: 'apikey',
            description: 'API key of the instance'
        }
    ]),
    __metadata("design:paramtypes", [instance_service_1.InstanceService])
], RemoveInstanceCommand);
//# sourceMappingURL=remove.command.js.map