<?php

namespace idoit\Module\Forms\Controller;

use idoit;
use idoit\Controller\Base;
use isys_application as Application;
use isys_auth;
use isys_component_tree;
use isys_controller as Controller;
use isys_exception_auth;
use isys_module;
use isys_module_forms;
use isys_register as Register;
use idoit\Module\Forms\Proxy\RequestProxy;

class Api extends Base implements Controller
{
    public function __construct(isys_module $p_module) { }

    public function dao(Application $p_application)
    {
        // TODO: Implement dao() method.
    }

    /**
     * @param Register    $p_request
     * @param Application $p_application
     *
     * @return idoit\View\Renderable|void
     * @throws \GuzzleHttp\Exception\GuzzleException
     * @throws isys_exception_auth
     */
    public function handle(Register $p_request, Application $p_application)
    {
        $session = $p_application->container->get('session');
        $language = $p_application->container->get('language');
        $proxy = new RequestProxy($session);
        $method = $_SERVER['REQUEST_METHOD'] ?? 'GET';
        $method = $method === 'PUT' ? 'PATCH' : $method;
        $body = file_get_contents('php://input');
        $parts = [];

        foreach ($p_request->get('GET') as $key => $value) {
            $parts[] = "$key=$value";
        }

        $url = implode('?', [
            $p_request->get('path'),
            implode('&', $parts)
        ]);

        $auth = isys_module_forms::getAuth();
        $allowedToCreate = $auth->is_allowed_to(isys_auth::CREATE, 'forms');
        $allowedToEdit = $auth->is_allowed_to(isys_auth::EDIT, 'forms');
        $allowedToDelete = $auth->is_allowed_to(isys_auth::DELETE, 'forms');

        // @see AOF-8 Check if the user is allowed to delete the form, before sending the request.
        if (strtolower($method) === 'post' && !$allowedToCreate) {
            // Post is used to create.
            throw new isys_exception_auth($language->get('LC__AUTH__EXCEPTION__MISSING_ACTION_RIGHT_FROM_MODULE', [
                $language->get('LC__AUTH__RIGHT_CREATE'),
                $language->get($auth->get_module_title())
            ]));
        }

        if (strtolower($method) === 'patch' && !$allowedToEdit) {
            // Put / Patch is used to edit, publish and unpublish.
            throw new isys_exception_auth($language->get('LC__AUTH__EXCEPTION__MISSING_ACTION_RIGHT_FROM_MODULE', [
                $language->get('LC__AUTH__RIGHT_EDIT'),
                $language->get($auth->get_module_title())
            ]));
        }

        if (strtolower($method) === 'delete' && !$allowedToDelete) {
            // Delete is used to delete.
            throw new isys_exception_auth($language->get('LC__AUTH__EXCEPTION__MISSING_ACTION_RIGHT_FROM_MODULE', [
                $language->get('LC__AUTH__RIGHT_DELETE'),
                $language->get($auth->get_module_title())
            ]));
        }

        $response = $proxy->proxy($method, $url, $body);
        http_response_code($response->getStatusCode());
        header('Content-Type: ' . $response->getHeader('Content-Type'));
        echo $response->getBody()->getContents();
        exit;
    }

    public function tree(Register $p_request, Application $p_application, isys_component_tree $p_tree)
    {
        // TODO: Implement tree() method.
    }
}
