<?php

namespace idoit\Module\Forms\Model\Validators;

use isys_cmdb_dao_category;

interface ValidatorInterface
{
  /**
   * @return bool
   */
  public function isApplicable(string $categoryConst): bool;

  /**
   * @param array                  $formData
   * @param isys_cmdb_dao_category $categoryDao
   *
   * @return array|null
   */
  public function validate(array $formData, isys_cmdb_dao_category $categoryDao): ?array;

  /**
   * @return static
   */
  public static function factory();
}
