import { Model } from 'mongoose';
import { FormDataDocument } from '../formData/schemas/form-data.schema';
import { CurrentInstance } from '../instance/currentInstance';
import { CreateFormDto } from './dto/create-form.dto';
import { UpdateFormDto } from './dto/update-form.dto';
import { FormDocument } from './schemas/form.schema';
import { FindFormDto } from './dto/find-form.dto';
import { SearchResult } from './schemas/SearchResult';
export declare class FormsService {
    private formModel;
    private formDataModel;
    private instance;
    constructor(formModel: Model<FormDocument>, formDataModel: Model<FormDataDocument>, instance: CurrentInstance);
    create(createFormDto: CreateFormDto): Promise<FormDocument>;
    findAll(find: FindFormDto): Promise<SearchResult<FormDocument>>;
    findOne(id: string): Promise<FormDocument>;
    findByIdentifier(identifier: string): Promise<FormDocument>;
    update(id: string, updateFormDto: UpdateFormDto): Promise<FormDocument>;
    remove(id: string): Promise<FormDocument>;
}
