"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FormsService = void 0;
const common_1 = require("@nestjs/common");
const mongoose_1 = require("@nestjs/mongoose");
const mongoose_2 = require("mongoose");
const form_data_schema_1 = require("../formData/schemas/form-data.schema");
const currentInstance_1 = require("../instance/currentInstance");
const filters_1 = require("../utils/Filters/filters");
const form_schema_1 = require("./schemas/form.schema");
const exception_1 = require("./exception");
let FormsService = class FormsService {
    constructor(formModel, formDataModel, instance) {
        this.formModel = formModel;
        this.formDataModel = formDataModel;
        this.instance = instance;
    }
    create(createFormDto) {
        return this.formModel.create(Object.assign(Object.assign({}, createFormDto), { created: new Date(), updated: new Date(), published: false, instance: this.instance.getCurrentInstance() }));
    }
    async findAll(find) {
        const filters = [{ instance: this.instance.getCurrentInstance() }];
        if (find.criteria) {
            const subFilter = (0, filters_1.filterConverter)(JSON.parse(find.criteria));
            if (subFilter) {
                filters.push(subFilter);
            }
        }
        const filter = { $and: filters };
        const count = await this.formModel.countDocuments(filter).exec();
        const results = find.limit > 0
            ? await this.formModel
                .find(filter)
                .sort(find.sorting || '_id')
                .skip(find.offset)
                .limit(find.limit)
                .exec()
            : [];
        return {
            offset: find.offset,
            count,
            results,
        };
    }
    findOne(id) {
        return this.formModel.findById(id).exec();
    }
    async findByIdentifier(identifier) {
        const form = await this.formModel
            .findOne({
            identifier: identifier,
            published: true,
        })
            .exec();
        if (!form) {
            throw new exception_1.FormNotFoundException(identifier);
        }
        return form;
    }
    async update(id, updateFormDto) {
        return this.formModel
            .findByIdAndUpdate(id, Object.assign(Object.assign({}, updateFormDto), { updated: new Date() }), { new: true })
            .exec();
    }
    async remove(id) {
        await this.formDataModel.deleteMany({ form: id });
        return this.formModel.findByIdAndDelete(id).exec();
    }
};
exports.FormsService = FormsService;
exports.FormsService = FormsService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, mongoose_1.InjectModel)(form_schema_1.Form.name)),
    __param(1, (0, mongoose_1.InjectModel)(form_data_schema_1.FormData.name)),
    __metadata("design:paramtypes", [mongoose_2.Model,
        mongoose_2.Model,
        currentInstance_1.CurrentInstance])
], FormsService);
//# sourceMappingURL=forms.service.js.map