<?php

namespace idoit\Module\Forms;

use idoit\Module\Multiedit\Model\CustomCategories;
use idoit\Module\Multiedit\Model\GlobalCategories;
use idoit\Module\Multiedit\Model\SpecificCategories;
use isys_application;

/**
 * Class with blocked categories and attributes
 *
 * @package   idoit\Module\Forms
 * @copyright synetics
 * @license
 */
class Blocked
{
  public const CATEGORIES = [
    'C__CATG__CUSTOM_FIELDS',
    'C__CATG__DATABASE_ASSIGNMENT',
    'C__CATG__FILE',
    'C__CATG__IDENTIFIER',
    'C__CATG__IMAGE',
    'C__CATG__IMAGES',
    'C__CATG__IP',
    'C__CATG__LAST_LOGIN_USER',
    'C__CATG__LOGBOOK',
    'C__CATG__RELATION',
    'C__CATG__NET_CONNECTOR',
    'C__CATG__NET_LISTENER',
    'C__CATG__OVERVIEW',
  ];

  public const ATTRIBUTES = [
    'C__CATG__CONTACT.contact',
    'C__CATG__GLOBAL.changed',
    'C__CATG__GLOBAL.changed_by',
    'C__CATG__GLOBAL.created',
    'C__CATG__GLOBAL.created_by',
    'C__CATG__GLOBAL.type',
    'C__CATG__SLA.days'
  ];

  /**
   * @return array
   */
  public static function getBlockedCategories()
  {
    $database = isys_application::instance()->container->get('database');
    $globalCategoriesBlocklist = GlobalCategories::instance($database)->getBlacklist();
    $specificCategoriesBlocklist = SpecificCategories::instance($database)->getBlacklist();
    $customCategoriesBlocklist = CustomCategories::instance($database)->getBlacklist();

    return [
      C__CMDB__CATEGORY__TYPE_GLOBAL => $globalCategoriesBlocklist,
      C__CMDB__CATEGORY__TYPE_SPECIFIC => $specificCategoriesBlocklist,
      C__CMDB__CATEGORY__TYPE_CUSTOM => $customCategoriesBlocklist
    ];
  }
}
