<?php

namespace idoit\Module\Forms\Exceptions;

use Exception;
use Symfony\Component\HttpFoundation\Response;

class CategoryException extends Exception
{
    /**
     * @param string $categoryType
     *
     * @return CategoryException
     */
    public static function CategoryTypeIsUnknown(string $categoryType)
    {
        return new self("Category Type {$categoryType} is unknown in i-doit!", Response::HTTP_NOT_FOUND);
    }

    /**
     * @param string $categoryConst
     *
     * @return CategoryException
     */
    public static function CategoryClassIsUnknown(string $categoryConst)
    {
        return new self("Category Class for category constant {$categoryConst} is unknown in i-doit!", Response::HTTP_NOT_FOUND);
    }
}
