<?php

namespace idoit\Module\Forms\Exceptions;

use Exception;
use Symfony\Component\HttpFoundation\Response;

class ProcessFormDataException extends Exception
{
    /**
     * @var array
     */
    private $issues = [];

    /**
     * @return array
     */
    public function getIssues(): array
    {
      return $this->issues;
    }

    /**
     * @param array $issues
     */
    public function setIssues(array $issues): void
    {
      $this->issues = $issues;
    }

    /**
     * @param array $issues
     *
     * @return ProcessFormDataException
     */
    public static function ValidationIssues(array $issues)
    {
       $exception = new self("Cannot create an object", Response::HTTP_BAD_REQUEST);
       $exception->setIssues($issues);

       return $exception;
    }

    /**
     * @param array $issues
     *
     * @return ProcessFormDataException
     */
    public static function PrepareDataIssues(array $issues)
    {
        $exception = new self("There are some issues while preparing the data before the merge.", Response::HTTP_BAD_REQUEST);
        $exception->setIssues($issues);

        return $exception;
    }

    /**
     * @param array $issues
     *
     * @return ProcessFormDataException
     */
    public static function SyncIssues(array $issues)
    {
        $exception = new self("There are some issues while preparing the data before the sync.", Response::HTTP_BAD_REQUEST);
        $exception->setIssues($issues);

        return $exception;
    }
}
