<?php

namespace idoit\Module\Forms\Exceptions;

use Exception;
use Symfony\Component\HttpFoundation\Response;

class ProcessorException extends Exception
{
    /**
     * @param string $categoryConst
     *
     * @return ProcessorException
     */
    public static function ProcessorCouldNotBeLoaded(string $categoryConst)
    {
        return new self("Processor for category const {$categoryConst} could not be loaded!", Response::HTTP_NOT_FOUND);
    }

    public static function ProcessorValidationError(string $message)
    {
        return new self($message, Response::HTTP_BAD_REQUEST);
    }
}
