<?php

namespace idoit\Module\Forms\Model\CategoryTypes\Virtual\Ip;

use idoit\Module\Forms\Model\CategoryTypes\Virtual\VirtualCategory;
use isys_cmdb_dao_category_g_ip;

abstract class Ip extends isys_cmdb_dao_category_g_ip
{
    /**
     * @var string
     */
    protected $categoryTitle = 'Ip';

    /**
     * @var string
     */
    protected $m_category_const = 'C__CATG__IP';

    /**
     * @return array
     */
    public function getRemovedProperties()
    {
        return [];
    }

    /**
     * @return array
     */
    public function properties(): array
    {
        return array_filter(parent::properties(), function ($key) {
            return !in_array($key, $this->getRemovedProperties());
        }, ARRAY_FILTER_USE_KEY);
    }
}
