<?php

namespace idoit\Module\Forms\Model;

use idoit\Model\Dao\Base;
use idoit\Module\Forms\Exceptions\DataByAttributeException;
use idoit\Module\Forms\Exceptions\ProcessorException;
use idoit\Module\Forms\Model\Processors\AbstractProcessor;
use idoit\Module\Forms\Model\Processors\AccountingProcessor;
use idoit\Module\Forms\Model\Processors\ApplicationAssignedObjProcessor;
use idoit\Module\Forms\Model\Processors\ApplicationProcessor;
use idoit\Module\Forms\Model\Processors\AuditProcessor;
use idoit\Module\Forms\Model\Processors\ChassisDeviceProcessor;
use idoit\Module\Forms\Model\Processors\ClusterMembershipsProcessor;
use idoit\Module\Forms\Model\Processors\ClusterMembersProcessor;
use idoit\Module\Forms\Model\Processors\ContactProcessor;
use idoit\Module\Forms\Model\Processors\CustomFieldsProcessor;
use idoit\Module\Forms\Model\Processors\GlobalProcessor;
use idoit\Module\Forms\Model\Processors\Ipv4Processor;
use idoit\Module\Forms\Model\Processors\Ipv6Processor;
use idoit\Module\Forms\Model\Processors\Layer2NetProcessor;
use idoit\Module\Forms\Model\Processors\LocationProcessor;
use idoit\Module\Forms\Model\Processors\ModelProcessor;
use idoit\Module\Forms\Model\Processors\NetProcessor;
use idoit\Module\Forms\Model\Processors\OperatingSystemProcessor;
use idoit\Module\Forms\Model\Processors\SlaProcessor;
use idoit\Module\Forms\Model\Processors\StorageDeviceProcessor;
use idoit\Module\Forms\Model\Processors\VirtualHostProcessor;
use isys_application;

class ProcessorDao
{
    /**
     * @var array
     */
    protected $processor = [];

    /**
     * @return ProcessorDao
     *
     * @throws DataByAttributeException
     * @throws ProcessorException
     * @throws \isys_exception_database
     */
    public static function factory()
    {
        return (new static())
          ->addProcessor(ApplicationAssignedObjProcessor::factory())
          ->addProcessor(ApplicationProcessor::factory())
          ->addProcessor(AccountingProcessor::factory())
          ->addProcessor(AuditProcessor::factory())
          ->addProcessor(ChassisDeviceProcessor::factory())
          ->addProcessor(ClusterMembershipsProcessor::factory())
          ->addProcessor(ClusterMembersProcessor::factory())
          ->addProcessor(ContactProcessor::factory())
          ->addProcessor(CustomFieldsProcessor::factory())
          ->addProcessor(GlobalProcessor::factory())
          ->addProcessor(Ipv4Processor::factory())
          ->addProcessor(Ipv6Processor::factory())
          ->addProcessor(LocationProcessor::factory())
          ->addProcessor(ModelProcessor::factory())
          ->addProcessor(NetProcessor::factory())
          ->addProcessor(OperatingSystemProcessor::factory())
          ->addProcessor(SlaProcessor::factory())
          ->addProcessor(StorageDeviceProcessor::factory())
          ->addProcessor(VirtualHostProcessor::factory());
    }

    /**
     * @param AbstractProcessor $processor
     *
     * @return ProcessorDao
     */
    public function addProcessor(AbstractProcessor $processor)
    {
        $this->processor[$processor::getCategoryConst()] = $processor;
        return $this;
    }

    /**
     * @param string $categoryConst
     *
     * @return AbstractProcessor|null
     *
     * @throws DataByAttributeException
     * @throws ProcessorException
     * @throws \isys_exception_database
     */
    public function getProcessor(string $categoryConst)
    {
      if (isset($this->processor[$categoryConst]) && $this->processor[$categoryConst] instanceof AbstractProcessor) {
        return $this->processor[$categoryConst];
      }
      return null;
    }
}
