<?php

namespace idoit\Module\Forms\Model\Validators\Category;

use idoit\Module\Forms\Model\Validators\GenericValidator;
use idoit\Module\Forms\Model\Validators\ValidatorInterface;
use isys_cmdb_dao_category;

class ConnectorValidator extends AbstractCategoryValidator implements ValidatorInterface
{
  public const CATEGORY_CONST = 'C__CATG__CONNECTOR';

  /**
   * @param array                  $formData
   * @param isys_cmdb_dao_category $categoryDao
   *
   * @return array|null
   */
  public function validate(array $formData, isys_cmdb_dao_category $categoryDao): ?array
  {
    return (GenericValidator::factory())
      ->setTablePrepend($categoryDao->get_table())
      ->validate($formData, $categoryDao);
  }
}
