<?php

namespace idoit\Module\Forms\Model\Validators;

use isys_cmdb_dao_category;

class ValidatorProvider
{
  /**
   * @var ValidatorInterface[]
   */
  private $validatorTypes = [];

  public static function factory()
  {
    $instance = new self();

    return $instance->loadValidators();
  }

  public function loadValidators()
  {
    $this->validatorTypes = [
      CategoryValidator::factory(),
      GenericValidator::factory()
    ];

    return $this;
  }

  /**
   * @param string $categoryConstant
   * @param array  $formData
   * @param isys_cmdb_dao_category $categoryDao
   *
   * @return array|null
   */
  public function validate($categoryConstant, array $formData, isys_cmdb_dao_category $categoryDao): ?array
  {
    foreach ($this->validatorTypes as $validatorType) {
      if ($validatorType->isApplicable($categoryConstant)) {
        return $validatorType->validate($formData, $categoryDao);
      }
    }

    return null;
  }
}
