<?php

/**
 * i-doit
 *
 * Class autoloader.
 *
 * @package     modules
 * @subpackage  maintenance
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.1
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.6.0
 */
class isys_module_maintenance_autoload extends isys_module_manager_autoload
{
    /**
     * Module specific autoloader.
     *
     * @param   string $className
     *
     * @return  boolean
     * @throws  Exception
     */
    public static function init($className)
    {
        $addOnPath = '/src/classes/modules/maintenance/';
        $classMap = [
            'isys_ajax_handler_maintenance' => 'handler/ajax/isys_ajax_handler_maintenance.class.php',
            'isys_cmdb_dao_category_g_virtual_maintenance' => 'cmdb/dao/isys_cmdb_dao_category_g_virtual_maintenance.class.php',
            'isys_cmdb_ui_category_g_virtual_maintenance' => 'cmdb/ui/isys_cmdb_ui_category_g_virtual_maintenance.class.php',
            'isys_handler_maintenance_notification' => 'handler/controller/isys_handler_maintenance_notification.class.php',
            'isys_maintenance_auth' => 'auth/isys_maintenance_auth.class.php',
            'isys_maintenance_dao' => 'dao/isys_maintenance_dao.class.php',
            'isys_maintenance_reportview_pdf' => 'reportview/isys_maintenance_reportview_pdf.class.php',
            'isys_maintenance_reportview_maintenance_export' => 'reportview/isys_maintenance_reportview_maintenance_export.class.php',
            'isys_popup_maintenance_finish' => 'popup/isys_popup_maintenance_finish.class.php',
        ];

        if (isset($classMap[$className]) && parent::include_file($addOnPath . $classMap[$className])) {
            isys_cache::keyvalue()->ns('autoload')->set($className, $addOnPath . $classMap[$className]);

            return true;
        }

        return false;
    }
}
