<?php

/**
 * i-doit
 *
 * "Finish" maintenance popup.
 *
 * @package     modules
 * @subpackage  pro
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.5.1
 */
class isys_popup_maintenance_finish extends isys_component_popup
{
    /**
     * This will not be used, because the popup will be called directly from JS.
     *
     * @param   isys_component_template &$p_tplclass
     * @param   array                   $p_params
     *
     * @return  string
     */
    public function handle_smarty_include(isys_component_template &$p_tplclass, $p_params)
    {
        return '';
    }

    /**
     * Method for handling the module request.
     *
     * @param   isys_module_request $p_modreq
     *
     * @return  null
     */
    public function &handle_module_request(isys_module_request $p_modreq)
    {
        $l_rules = [
            'C__MAINTENANCE__POPUP__FINISH_COMMENT' => [
                'p_strClass' => 'input-small'
            ]
        ];

        $this->template->activate_editmode()
            ->assign('ajax_url', isys_helper_link::create_url([
                C__GET__AJAX      => 1,
                C__GET__AJAX_CALL => 'maintenance'
            ]))
            ->smarty_tom_add_rules('tom.popup.maintenance', $l_rules)
            ->display(isys_module_maintenance::getPath() . 'templates/popup/finish_maintenance.tpl');
        die;
    }
}