<?php

use Carbon\Carbon;
use idoit\Module\Maintenance\Model\Overview;

/**
 * i-doit
 *
 * Maintenance report view.
 *
 * @package     modules
 * @subpackage  maintenance
 * @version     1.0.2
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.5.1
 */
class isys_maintenance_reportview_maintenance_export extends isys_report_view
{
    /**
     * Method for ajax-requests.
     */
    public function ajax_request()
    {
    }

    /**
     * Method for retrieving the language constant of the report-description.
     *
     * @return  string
     * @todo    Should we update the parent method to retrieve this automatically?
     */
    public static function description()
    {
        return 'LC__REPORT__VIEW__MAINTENANCE_EXPORT_DESCRIPTION';
    }

    /**
     * Determines, if a report view is brought in by an external source (module?).
     *
     * @return  boolean
     */
    public function external()
    {
        return true;
    }

    /**
     * Initialize method.
     *
     * @return  boolean
     */
    public function init()
    {
        return true;
    }

    /**
     * Method for retrieving the language constant of the report-name.
     *
     * @return  string
     * @todo    Should we update the parent method to retrieve this automatically?
     */
    public static function name()
    {
        return 'LC__REPORT__VIEW__MAINTENANCE_EXPORT';
    }

    /**
     * Start-method - Implement the logic for displaying your data here.
     *
     * @return  void
     */
    public function start()
    {
        $startOfYear = isys_application::instance()->container->get('locales')->fmt_date(Carbon::now()->startOfYear()->timestamp);
        $endOfYear = isys_application::instance()->container->get('locales')->fmt_date(Carbon::now()->endOfYear()->timestamp);

        $l_rules = [
            'C__REPORT__VIEW__MAINTENANCE_EXPORT__TITLE' => [
                'p_strPlaceholder' => $this->language->get('LC__MAINTENANCE__PDF__TITLE') . ' (' . $startOfYear . ' - ' . $endOfYear . ')',
                'p_strClass'       => 'input-small'
            ],
            'C__REPORT__VIEW__MAINTENANCE_EXPORT__TYPE'  => [
                'p_strTable' => 'isys_maintenance_type',
                'p_strClass' => 'input-small'
            ],
            'C__REPORT__VIEW__MAINTENANCE_EXPORT__FROM'  => [
                'p_strValue'     => $startOfYear,
                'p_strPopupType' => 'calendar',
                'p_strClass'     => 'input-small'
            ],
            'C__REPORT__VIEW__MAINTENANCE_EXPORT__TO'    => [
                'p_strValue'     => $endOfYear,
                'p_strPopupType' => 'calendar',
                'p_strClass'     => 'input-small'
            ],
            'C__REPORT__VIEW__MAINTENANCE_EXPORT__LOGO'  => [
                'p_strClass' => 'input-small'
            ]
        ];

        if (isset($_GET['download_export']) && $_GET['download_export']) {
            try {
                $l_pdf = $this->createPdf($_GET['title'], $_GET['date_from'], $_GET['date_to'], array_filter(explode(',', $_GET['type'])), $_GET['logo_obj_id']);

                $l_pdf->Output($this->language->get('LC__REPORT__VIEW__MAINTENANCE_EXPORT__FILENAME') . '.pdf', 'D');
            } catch (Exception $e) {
                isys_notify::error($e->getMessage(), ['sticky' => true]);

                // Refill all formfields.
                $l_rules['C__REPORT__VIEW__MAINTENANCE_EXPORT__TITLE']['p_strValue'] = $_GET['title'];
                $l_rules['C__REPORT__VIEW__MAINTENANCE_EXPORT__TYPE']['p_strSelectedID'] = $_GET['type'];
                $l_rules['C__REPORT__VIEW__MAINTENANCE_EXPORT__FROM']['p_strValue'] = $_GET['date_from'];
                $l_rules['C__REPORT__VIEW__MAINTENANCE_EXPORT__TO']['p_strValue'] = $_GET['date_to'];
                $l_rules['C__REPORT__VIEW__MAINTENANCE_EXPORT__LOGO']['p_strSelectedID'] = $_GET['logo_obj_id'];
            }
        }

        // Assign the ajax URL to the template.
        $this->template
            ->activate_editmode()
            ->smarty_tom_add_rules('tom.content.bottom.content', $l_rules)
            ->assign('ajax_url', isys_glob_add_to_query('ajax', 1))
            ->assign('url', isys_helper_link::create_url($_GET));
    }

    /**
     * Method for retrieving the template-name of this report.
     *
     * @return  string
     * @todo    Should we update the parent method to retrieve this automatically?
     */
    public function template()
    {
        return __DIR__ . '/view_maintenance_export.tpl';
    }

    /**
     * Method for declaring the type of this report.
     *
     * @return  integer
     */
    public static function type()
    {
        return self::c_php_view;
    }

    /**
     * Method for declaring the view-type.
     *
     * @return  string
     */
    public static function viewtype()
    {
        return 'LC__MODULE__MAINTENANCE';
    }

    /**
     * Method for processing the PDF creation. Will return the class instance for further processing.
     *
     * @param   string  $pdfTitle
     * @param   string  $dateFrom
     * @param   string  $dateTo
     * @param   array|null   $types
     * @param   integer $logoFileId
     *
     * @return  isys_maintenance_reportview_pdf
     * @throws  isys_exception_database
     */
    public function createPdf($pdfTitle, $dateFrom, $dateTo, array $types = null, $logoFileId = null)
    {
        $locales = isys_application::instance()->container->get('locales');

        $logoImagePath = '';

        if (is_numeric($logoFileId) && $logoFileId > 0) {
            $l_filename = isys_cmdb_dao_category_s_file::instance($this->database)
                ->get_file_by_obj_id($logoFileId)
                ->get_row_value('isys_file_physical__filename');

            // @see WARTUNG-64 Fix the bug by using the proper method.
            $logoImagePath = isys_application::instance()->getUploadFilePath($l_filename);
        }

        $data = (new Overview($this->database))->getDataByTimespan(
            new DateTime($dateFrom),
            new DateTime($dateTo),
            $types
        );

        $maintenanceData = [];

        /** @var array $maintenances */
        $maintenances = $data['maintenances'];

        foreach ($maintenances as $maintenance) {
            foreach ($maintenance['dates'] as $date) {
                $maintenanceData[] = array_merge($maintenance, $date);
            }
        }

        usort($maintenanceData, function ($a, $b) {
            return strcmp($a['from'], $b['from']);
        });

        $l_title = $pdfTitle ?: $this->language
                ->get('LC__MAINTENANCE__PDF__TITLE') . ' (' . $locales->fmt_datetime($dateFrom) . ' - ' . $locales->fmt_datetime($dateTo) . ')';

        return (new isys_maintenance_reportview_pdf('P'))->SetTitle($l_title)
            ->set_logo_filepath($logoImagePath)
            ->set_maintenance_data($maintenanceData)
            ->set_object_data($data['objects'])
            ->first_page()
            ->fill_report();
    }
}
