<?php

use idoit\Console\IdoitConsoleApplication;
use idoit\Module\Maintenance\Console\Command\MaintenanceNotificationCommand;
use Symfony\Component\Console\Input\ArrayInput;
use Symfony\Component\Console\Output\ConsoleOutput;

/**
 * Controller for writing notification e-mails, which have not already been sent.
 *
 * @package     Modules
 * @subpackage  Maintenance
 * @author      Leonard Fischer <lfischer@i-doit.org>
 * @version     1.0.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.6.0
 */
class isys_handler_maintenance_notification extends isys_handler
{
    /**
     * Initialization method.
     *
     * @global  isys_component_session  $g_comp_session
     * @global  isys_component_database $g_comp_database
     * @return  boolean
     */
    public function init()
    {
        global $g_comp_session;

        if ($g_comp_session->is_logged_in())
        {
            $application = new IdoitConsoleApplication();
            $application->setAutoExit(false);

            $output = new ConsoleOutput();

            $output->writeln('<error>isys_handler_maintenance_notification is deprecated, please use php console.php MaintenanceNotification instead</error>');

            $commandParams = [
                'command' => 'MaintenanceNotification',
                '--user' => 'loginBefore',
                '--password' => 'loginBefore',
                '--mandatorId' => 'loginBefore'
            ];

            /**
             * @var $command \idoit\Console\Command\AbstractCommand
             */
            $command = new MaintenanceNotificationCommand();
            $command->setSession($g_comp_session);
            $command->setContainer(\isys_application::instance()->container);
            $command->setAuth(\isys_auth_system::instance());

            $application->add($command);

            $application->run(new ArrayInput($commandParams), $output);
        } // if

        return false;
    } // function
} // class
