<?php

/**
 * i-doit maintenance module installer.
 *
 * @package     i-doit
 * @subpackage  maintenance
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.5.1
 */
class isys_module_maintenance_install
{
    /**
     * Init method.
     *
     * @param  isys_component_database $database
     * @param  isys_component_database $systemDatabase
     * @param  integer                 $moduleId
     * @param  string                  $mode
     *
     * @throws isys_exception_dao
     * @throws isys_exception_database
     */
    public static function init($database, $systemDatabase, $moduleId, $mode)
    {
        if ($mode === 'install') {
            $authMethods = [
                'PLANNING'         => (isys_auth::VIEW + isys_auth::EDIT + isys_auth::DELETE),
                'PLANNING_ALL'     => (isys_auth::VIEW + isys_auth::EDIT + isys_auth::DELETE),
                'PLANNING_ARCHIVE' => (isys_auth::VIEW + isys_auth::EDIT + isys_auth::DELETE),
                'MAILTEMPLATE'     => (isys_auth::VIEW + isys_auth::EDIT + isys_auth::DELETE),
                'OVERVIEW'         => isys_auth::VIEW,
                'SEND_MAILS'       => isys_auth::EXECUTE,
            ];
        } else {
            $authMethods = [
                'PLANNING_ALL' => (isys_auth::VIEW + isys_auth::EDIT + isys_auth::DELETE)
            ];
        }

        $dao = isys_cmdb_dao::instance($database);

        if ($moduleId > 0) {
            $sqlQueries = [];

            $users = [
                $dao->retrieve('SELECT isys_obj__id FROM isys_obj WHERE isys_obj__const = "C__OBJ__PERSON_GROUP_ADMIN";')->get_row_value('isys_obj__id'),
                $dao->retrieve('SELECT isys_obj__id FROM isys_obj WHERE isys_obj__const = "C__OBJ__PERSON_GROUP_AUTHOR";')->get_row_value('isys_obj__id'),
                $dao->retrieve('SELECT isys_obj__id FROM isys_obj WHERE isys_obj__const = "C__OBJ__PERSON_GROUP_EDITOR";')->get_row_value('isys_obj__id')
            ];

            $reader = $dao->retrieve('SELECT isys_obj__id FROM isys_obj WHERE isys_obj__const = "C__OBJ__PERSON_GROUP_READER";')->get_row_value('isys_obj__id');

            $users = array_filter($users);

            foreach ($users as $user) {
                foreach ($authMethods as $method => $right) {
                    $sqlQueries[] = 'INSERT isys_auth
                        SET isys_auth__isys_obj__id = ' . $dao->convert_sql_id($user) . ',
                        isys_auth__type = ' . $dao->convert_sql_int($right) . ',
                        isys_auth__isys_module__id = ' . $dao->convert_sql_id($moduleId) . ',
                        isys_auth__path = ' . $dao->convert_sql_text($method) . ';';
                }
            }

            if ($reader > 0) {
                foreach ($authMethods as $method => $right) {
                    $sqlQueries[] = 'INSERT isys_auth
                        SET isys_auth__isys_obj__id = ' . $dao->convert_sql_id($reader) . ',
                        isys_auth__type = ' . $dao->convert_sql_int(isys_auth::VIEW) . ',
                        isys_auth__isys_module__id = ' . $dao->convert_sql_id($moduleId) . ',
                        isys_auth__path = ' . $dao->convert_sql_text($method) . ';';
                }
            }

            if (count($sqlQueries)) {
                foreach ($sqlQueries as $sql) {
                    $dao->update($sql) && $dao->apply_update();
                }
            }
        }
    }
}
