<?php

use idoit\Module\Maintenance\Component\Mailer;
use idoit\Module\Maintenance\Model\Overview;

/**
 * i-doit
 *
 * AJAX controller
 *
 * @package     modules
 * @subpackage  maintenance
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_ajax_handler_maintenance extends isys_ajax_handler
{
    /**
     * Init method, which gets called from the framework.
     */
    public function init()
    {
        // We set the header information because we don't accept anything than JSON.
        header('Content-Type: application/json');

        $l_return = [
            'success' => true,
            'message' => null,
            'data'    => null
        ];

        try {
            switch ($_GET['func']) {
                case 'get-filtered-planning-list':
                    $l_return['data'] = $this->getPlanningList($_POST['from'], $_POST['to']);
                    break;

                case 'finish-maintenances':
                    $l_return['data'] = $this->finishMaintenance(isys_format_json::decode($_POST['ids']), $_POST['comment']);
                    break;

                case 'send-planning-email':
                    $l_return['data'] = $this->sendPlanningEmail(isys_format_json::decode($_POST['ids']));
                    break;
            }
        } catch (isys_exception $e) {
            $l_return['success'] = false;
            $l_return['message'] = $e->getMessage();
        }

        echo isys_format_json::encode($l_return);

        $this->_die();
    }

    /**
     * This method defines, if the hypergate needs to be included for this request.
     *
     * @static
     * @return  boolean
     */
    public static function needs_hypergate()
    {
        return true;
    }

    /**
     * Method for triggering the "completion" of a maintenance planning.
     *
     * @param array  $p_ids
     * @param string $p_comment
     *
     * @return array
     */
    public function finishMaintenance(array $p_ids, $p_comment): array
    {
        $l_return = [];
        $l_dao = new isys_maintenance_dao($this->m_database_component);

        if (!count($p_ids)) {
            return $l_return;
        }

        foreach ($p_ids as $l_id) {
            try {
                $l_return[$l_id] = $l_dao->finish_maintenance_planning($l_id, $p_comment);
            } catch (Exception $e) {
                $l_return[$l_id] = $e->getMessage();
            }
        }

        return $l_return;
    }

    /**
     * Method for triggering the "email" of a maintenance planning.
     *
     * @param array $p_ids
     *
     * @return array
     * @throws Exception
     */
    public function sendPlanningEmail(array $p_ids): array
    {
        $l_return = [];
        $mailer = new Mailer(isys_application::instance()->container->get('database'), isys_application::instance()->container->get('locales'));

        if (!count($p_ids)) {
            return $l_return;
        }

        foreach ($p_ids as $l_id) {
            try {
                $l_return[$l_id] = $mailer->sendMaintenancePlanningMail($l_id);
            } catch (Exception $e) {
                $l_return[$l_id] = $e->getMessage();
            }
        }

        return $l_return;
    }

    /**
     * Method for retrieving maintenance plannings during a given timeperiod.
     *
     * @param string $p_from
     * @param string $p_to
     *
     * @return array
     * @throws isys_exception_database
     */
    protected function getPlanningList($p_from = null, $p_to = null)
    {
        return (new Overview($this->m_database_component))->getDataByTimespan(
            (new DateTime($p_from))->setTime(0, 0, 0),
            (new DateTime($p_to))->setTime(23, 59, 59)
        );
    }
}
