<?php

namespace idoit\Module\Maintenance\Model;

use isys_cmdb_dao;
use isys_component_dao_result;
use isys_exception_dao;
use isys_exception_database;

/**
 * i-doit
 *
 * Maintenance model for "mailtemplate".
 *
 * @package     idoit\Module\Maintenance\Model
 * @package     maintenance
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class Mailtemplate extends isys_cmdb_dao
{
    /**
     * @var  array
     */
    protected $mailtemplateFields = [
        'isys_maintenance_mailtemplate__id'     => 'convert_sql_id',
        'isys_maintenance_mailtemplate__title'  => 'convert_sql_text',
        'isys_maintenance_mailtemplate__text'   => 'convert_sql_text',
        'isys_maintenance_mailtemplate__report' => 'convert_sql_text',
        'isys_maintenance_mailtemplate__status' => 'convert_sql_int'
    ];

    /**
     * Method for retrieving mailtemplate data.
     *
     * @param int|null $id
     * @param string   $condition
     *
     * @return isys_component_dao_result
     * @throws isys_exception_database
     */
    public function getMailtemplates($id = null, $condition = ''): isys_component_dao_result
    {
        $sql = 'SELECT * FROM isys_maintenance_mailtemplate WHERE TRUE ' . $condition;

        if ($id !== null) {
            if (is_array($id)) {
                $sql .= 'AND isys_maintenance_mailtemplate__id ' . $this->prepare_in_condition($id) . ' ';
            } else {
                $sql .= 'AND isys_maintenance_mailtemplate__id  = ' . $this->convert_sql_id($id) . ' ';
            }
        }

        return $this->retrieve($sql . ';');
    }

    /**
     * Method for saving a maintenance mailtemplate.
     *
     * @param int|null $id
     * @param array    $data
     *
     * @return int
     * @throws isys_exception_dao
     * @throws isys_exception_database
     */
    public function saveMailtemplate($id = null, array $data = []): int
    {
        $queryData = [];

        foreach ($data as $key => $value) {
            if (isset($this->mailtemplateFields[$key])) {
                $queryData[] = $key . ' = ' . call_user_func([$this, $this->mailtemplateFields[$key]], $value);
            }
        }

        if (count($queryData)) {
            if ($id === null) {
                $sql = 'INSERT INTO isys_maintenance_mailtemplate SET ' . implode(', ', $queryData);
            } else {
                $sql = 'UPDATE isys_maintenance_mailtemplate SET ' . implode(', ', $queryData) . ' WHERE isys_maintenance_mailtemplate__id = ' . $this->convert_sql_id($id);
            }

            if ($this->update($sql) && $this->apply_update()) {
                if ($id === null) {
                    $id = $this->get_last_id_from_table('isys_maintenance_mailtemplate');
                }
            } else {
                throw new isys_exception_database($this->m_last_error);
            }
        }

        return (int)$id;
    }

    /**
     * Method for deleting mailtemplates.
     *
     * @param int|array $id
     *
     * @return bool
     * @throws isys_exception_dao
     */
    public function deleteMailtemplate($id): bool
    {
        if (!is_array($id)) {
            $id = [$id];
        }

        $sql = 'DELETE FROM isys_maintenance_mailtemplate WHERE isys_maintenance_mailtemplate__id ' . $this->prepare_in_condition($id) . ';';

        return ($this->update($sql) && $this->apply_update());
    }
}
