<div id="maintenance-list">[{$list}]</div>

<script type="text/javascript">
    (function () {
        'use strict';

        const $table = $('maintenance-list').down('.table-container .table-body');
        const $send_email_button = $('navbar_item_maintenance_send_mail');

        if ($send_email_button) {
            $send_email_button.on('click', function () {
                const $plannings = $table.select('input:checked');
                const already_dispatched = [];
                const ids = [];
                const last_errors = [];

                if ($plannings.length === 0) {
                    idoit.Notify.warning('[{isys type="lang" ident="LC__MAINTENANCE__SEND_MAIL_NO_PLANNING_SELECTED" p_bHtmlEncode=false}]', {life:10});
                    return;
                }

                $plannings.each(function ($el) {
                    const $tr = $el.up('tr');
                    const id = +$el.getValue();

                    if ($tr.down('span[data-mail-dispatched="1"]')) {
                        already_dispatched.push($tr.down('td', 2).innerText + ' (#' + id + ')');
                    }

                    ids.push(id);
                });

                const confirm_message = already_dispatched.length > 0
                    ? '[{isys type="lang" ident="LC__MAINTENANCE__SEND_MAIL_AGAIN_CONFIRM" p_bHtmlEncode=false}]'.replace('%s', already_dispatched.join(', '))
                    : '[{isys type="lang" ident="LC__MAINTENANCE__SEND_MAIL_CONFIRM" p_bHtmlEncode=false}]';

                if (confirm(confirm_message)) {
                    $send_email_button
                        .down('img').addClassName('animation-rotate').writeAttribute('src', window.dir_images + 'axialis/user-interface/loading.svg')
                        .next('span').update('[{isys type="lang" ident="LC__UNIVERSAL__LOADING"}]');

                    new Ajax.Request('[{$ajax_url}]&func=send-planning-email', {
                        parameters: {
                            ids: Object.toJSON(ids)
                        },
                        onSuccess: function (response) {
                            var json = response.responseJSON, i;

                            if (json.success) {
                                for (i in json.data) {
                                    if (json.data.hasOwnProperty(i) && json.data[i] !== true) {
                                        last_errors.push(json.data[i]);
                                    }
                                }
                            } else {
                                last_errors.push(json.message || response.responseText);
                            }
                        },
                        onFailure: function (response) {
                            last_errors.push(response.responseText);
                        },
                        onComplete: function () {
                            $send_email_button
                                .down('img').removeClassName('animation-rotate').writeAttribute('src', window.dir_images + 'axialis/web-email/mail-back-all.svg')
                                .next('span').update('[{isys type="lang" ident="LC__MAINTENANCE__SEND_MAIL"}]');

                            if (last_errors.length > 0) {
                                idoit.Notify.error('[{isys type="lang" ident="LC__MAINTENANCE__SEND_MAIL_FAILURE"}]' + last_errors.join('<br />'), {sticky:true});
                            } else {
                                idoit.Notify.success('[{isys type="lang" ident="LC__MAINTENANCE__SEND_MAIL_SUCCESS"}]', {sticky:true});

                                document.location.reload(true);
                            }
                        }
                    });
                }
            });
        }
    })();
</script>
