<?php

/**
 * i-doit
 *
 * Maintenance category DAO.
 *
 * @package     modules
 * @subpackage  maintenance
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.5.1
 */
class isys_cmdb_dao_category_g_virtual_maintenance extends isys_cmdb_dao_category_g_virtual
{
    public function __construct(isys_component_database $p_db)
    {
        $this->m_category = 'virtual_maintenance';

        parent::__construct($p_db);
    }

    /**
     * Method for retrieving all maintenances of a given object.
     *
     * @param int  $objectId
     * @param bool $orderAscending
     *
     * @return isys_component_dao_result
     * @throws isys_exception_database
     */
    public function getMaintenancesByObject(int $objectId, bool $orderAscending = true)
    {
        $oderDirection = $orderAscending ? 'ASC' : 'DESC';

        $l_sql = "SELECT * FROM isys_maintenance
			INNER JOIN isys_maintenance_2_object ON isys_maintenance_2_object__isys_maintenance__id = isys_maintenance__id
			WHERE isys_maintenance_2_object__isys_obj__id = {$objectId}
			ORDER BY isys_maintenance__date_from {$oderDirection};";

        return $this->retrieve($l_sql . ';');
    }
}
