<?php

namespace idoit\Module\Maintenance\Model;

use Exception;
use isys_cmdb_dao;
use isys_component_dao_result;
use isys_exception_dao;
use isys_exception_database;

/**
 * i-doit
 *
 * Maintenance model for "contact".
 *
 * @package     idoit\Module\Maintenance\Model
 * @package     maintenance
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       Maintenance 1.1
 */
class Contact extends isys_cmdb_dao
{
    /**
     * Retrieves all contact objects by tag ID.
     * Original code from `isys_cmdb_dao_category_g_contact->get_contact_objects_by_tag()`.
     *
     * @param int       $p_obj_id
     * @param int|array $p_tag_id
     *
     * @return isys_component_dao_result
     * @throws isys_exception_database
     */
    public function getByObjectAndTag($p_obj_id = null, $p_tag_id = null)
    {
        $l_tag_condition = '';

        if (is_array($p_tag_id)) {
            $l_tag_condition = ' AND isys_contact_tag__id IN(' . implode(',', $p_tag_id) . ') ';
        } elseif ($p_tag_id !== null) {
            $l_tag_condition = ' AND isys_contact_tag__id = ' . $this->convert_sql_id($p_tag_id) . ' ';
        }

        if ($p_obj_id !== null) {
            $l_tag_condition .= ' AND isys_catg_contact_list__isys_obj__id = ' . $this->convert_sql_id($p_obj_id);
        }

        $l_query = 'SELECT isys_obj.*, isys_catg_contact_list.*, isys_contact_tag.* FROM isys_catg_contact_list
            INNER JOIN isys_connection ON isys_connection__id = isys_catg_contact_list__isys_connection__id
            INNER JOIN isys_obj ON isys_connection__isys_obj__id = isys_obj__id
            LEFT JOIN isys_contact_tag ON isys_contact_tag__id = isys_catg_contact_list__isys_contact_tag__id
            WHERE TRUE ' . $l_tag_condition . ';';

        return $this->retrieve($l_query);
    }
}
