<table cellspacing="0" cellpadding="0" id="maintenance-overview-filter">
	<tr>
		<td>
			[{isys type="f_label" name="C__MAINTENANCE__OVERVIEW__FILTER__DATE_FROM" ident="LC__MAINTENANCE__OVERVIEW__FILTER__DATE_FROM"}]<br />
			[{isys type="f_popup" name="C__MAINTENANCE__OVERVIEW__FILTER__DATE_FROM"}]
		</td>
		<td>
			[{isys type="f_label" name="C__MAINTENANCE__OVERVIEW__FILTER__DATE_TO" ident="LC__MAINTENANCE__OVERVIEW__FILTER__DATE_TO"}]<br />
			[{isys type="f_popup" name="C__MAINTENANCE__OVERVIEW__FILTER__DATE_TO"}]
		</td>
		<td>
			<button id="C__MAINTENANCE__OVERVIEW__RESET_BUTTON" type="button" class="btn">
				<img src="[{$dir_images}]axialis/basic/symbol-cancel.svg" class="mr5" />
				<span>[{isys type="lang" ident="LC__MAINTENANCE__OVERVIEW__FILTER_RESET_BUTTON"}]</span>
			</button>

			<button id="C__MAINTENANCE__OVERVIEW__FILTER_BUTTON" type="button" class="btn ml5">
				<img src="[{$dir_images}]axialis/basic/symbol-ok.svg" class="mr5" />
				<span>[{isys type="lang" ident="LC__MAINTENANCE__OVERVIEW__FILTER_BUTTON"}]</span>
			</button>
		</td>
	</tr>
</table>

<div id="maintenance-overview-list" class="mt5">
	<div id="maintenance-overview-list-loader"></div>

	<h3 class="p5 bg-neutral-200 border-top border-bottom cb">[{isys type="lang" ident="LC__MAINTENANCE__OVERVIEW__LIST_PAST"}]</h3>
	<div id="maintenance-overview-list-past" class="p5 timeperiod"></div>

	<h3 class="p5 bg-neutral-200 border-top border-bottom cb">[{isys type="lang" ident="LC__MAINTENANCE__OVERVIEW__LIST_THIS_WEEK"}]</h3>
	<div id="maintenance-overview-list-this-week" class="p5 timeperiod"></div>

	<h3 class="p5 bg-neutral-200 border-top border-bottom cb">[{isys type="lang" ident="LC__MAINTENANCE__OVERVIEW__LIST_THIS_MONTH"}]</h3>
	<div id="maintenance-overview-list-this-month" class="p5 timeperiod"></div>

	<h3 class="p5 bg-neutral-200 border-top border-bottom cb">[{isys type="lang" ident="LC__MAINTENANCE__OVERVIEW__LIST_NEXT_WEEK"}]</h3>
	<div id="maintenance-overview-list-next-week" class="p5 timeperiod"></div>

	<h3 class="p5 bg-neutral-200 border-top border-bottom cb">[{isys type="lang" ident="LC__MAINTENANCE__OVERVIEW__LIST_NEXT_MONTH"}]</h3>
	<div id="maintenance-overview-list-next-month" class="p5 timeperiod"></div>

	<h3 class="p5 bg-neutral-200 border-top border-bottom cb">[{isys type="lang" ident="LC__MAINTENANCE__OVERVIEW__LIST_FUTURE"}]</h3>
	<div id="maintenance-overview-list-future" class="p5 timeperiod"></div>

	<br class="cb" />
</div>

<style type="text/css">
	#maintenance-overview-filter {
		padding: 10px 0;
	}

	#maintenance-overview-filter td {
		padding: 0 10px;
		vertical-align: top;
	}

	#maintenance-overview-filter td:last-child {
		vertical-align: bottom;
	}

	#maintenance-overview-list .maintenance-object {
		width: 250px;
		min-height: 100px;
		margin: 0 5px 5px 0;
		background: #fff;
		position: relative;
		box-sizing: border-box;
	}

	#maintenance-overview-list ul {
		margin: 0;
		list-style: outside none none;
	}

	#maintenance-overview-list li {
		margin: 2px 5px;
	}

	#maintenance-overview-list .maintenance-object img.obj-image {
		width: 150px;
		margin-left: 50px;
	}
</style>
<script type="text/javascript">
	(function () {
		'use strict';

		var objects,
			maintenances,
			last_error = '',
			$from = $('C__MAINTENANCE__OVERVIEW__FILTER__DATE_FROM__HIDDEN'),
			$to = $('C__MAINTENANCE__OVERVIEW__FILTER__DATE_TO__HIDDEN'),
			$filter_button = $('C__MAINTENANCE__OVERVIEW__FILTER_BUTTON'),
			$reset_button = $('C__MAINTENANCE__OVERVIEW__RESET_BUTTON'),
			$list = $('maintenance-overview-list'),
			$list_loader = $('maintenance-overview-list-loader').hide(),
			$list_past = $('maintenance-overview-list-past'),
			$list_this_week = $('maintenance-overview-list-this-week'),
			$list_this_month = $('maintenance-overview-list-this-month'),
			$list_next_week = $('maintenance-overview-list-next-week'),
			$list_next_month = $('maintenance-overview-list-next-month'),
			$list_future = $('maintenance-overview-list-future'),
			object_elements = {},
			this_week = parseInt('[{$this_week}]'),
			this_month = parseInt('[{$this_month}]'),
			next_week = parseInt('[{$next_week}]'),
			next_month = parseInt('[{$next_month}]'),
			next_next_month = parseInt('[{$next_next_month}]');

		$reset_button.on('click', function () {
			$('C__MAINTENANCE__OVERVIEW__FILTER__DATE_FROM__VIEW', 'C__MAINTENANCE__OVERVIEW__FILTER__DATE_FROM__HIDDEN', 'C__MAINTENANCE__OVERVIEW__FILTER__DATE_TO__VIEW', 'C__MAINTENANCE__OVERVIEW__FILTER__DATE_TO__HIDDEN').invoke('setValue', '');
		});

		$filter_button.on('click', function () {
			$list_loader.show();

			$filter_button
				.down('img').addClassName('animation-rotate').writeAttribute('src', window.dir_images + 'axialis/user-interface/loading.svg')
				.next('span').update('[{isys type="lang" ident="LC__UNIVERSAL__LOADING"}]');

			new Ajax.Request('[{$ajax_url}]&func=get-filtered-planning-list', {
					parameters: {
						from: $from.getValue(),
						to: $to.getValue()
					},
					onSuccess: function (response) {
						var json = response.responseJSON;

						if (json.success) {
							objects = json.data.objects;
							maintenances = json.data.maintenances;
						} else {
							objects = false;
							maintenances = false;
							last_error = json.message || response.responseText;
						}
					},
					onFailure: function (response) {
						objects = false;
						last_error = response.responseText;
					},
					onComplete: function () {
						$list_loader.hide();
						$filter_button
							.down('img').removeClassName('animation-rotate').writeAttribute('src', window.dir_images + 'axialis/basic/symbol-ok.svg')
							.next('span').update('[{isys type="lang" ident="LC__MAINTENANCE__OVERVIEW__FILTER_BUTTON"}]');

						render_list();
					}
				});
		});

		function render_list () {
			var date, obj, item, role_people, $usage, $object, $object_ul, i, j, list_width = ($list.getWidth() - 15), maintenance;

			// First we flush the contents.
			$list_past.update().store('count', 0);
			$list_this_month.update().store('count', 0);
			$list_this_week.update().store('count', 0);
			$list_next_week.update().store('count', 0);
			$list_next_month.update().store('count', 0);
			$list_future.update().store('count', 0);

			// And then we hide all containers.
			$list.select('.timeperiod').invoke('hide')
				.invoke('previous').invoke('hide');

			if (!objects || !maintenances) {
				$list.update(new Element('p', { className: 'box-red m5 p5' })
					.update(new Element('img', { src: window.dir_images + 'axialis/basic/warning.svg', className: 'mr5' }))
					.insert(new Element('span').update(last_error)));

				return;
			}

			for (obj in objects) {
				if (objects.hasOwnProperty(obj)) {
					item = objects[obj];

					object_elements[obj] = new Element('div', {className:'fl border maintenance-object', 'data-object-id': item.isys_obj__id})
						.update(new Element('strong', {className:'p5 display-block'})
							.update(new Element('img', {className:'mr5 vam', src:item.isys_obj_type__icon, width:'16px', height:'16px'}))
							.insert(new Element('span').update(item.isys_obj_type__title + ' &raquo; ' + item.isys_obj__title)))
						.insert(new Element('img', {className:'obj-image', src:item.image}))
						.insert(new Element('ul'));
				}
			}

            for (i in maintenances) {
                if (!maintenances.hasOwnProperty(i)) {
                    continue;
                }

                maintenance = maintenances[i];

                for (date in maintenance.dates) {
                    if (!maintenance.dates.hasOwnProperty(date)) {
                        continue;
                    }

                    if (maintenance.dates[date].from < this_month) {
                        $usage = $list_past;
                    } else if (maintenance.dates[date].from >= this_month && maintenance.dates[date].from < this_week) {
                        $usage = $list_this_month;
                    } else if (maintenance.dates[date].from >= this_week && maintenance.dates[date].from < next_week) {
                        $usage = $list_this_week;
                    } else if (maintenance.dates[date].from >= next_week && maintenance.dates[date].from < next_month) {
                        $usage = $list_next_week;
                    } else if (maintenance.dates[date].from >= next_month && maintenance.dates[date].from < next_next_month) {
                        $usage = $list_next_month;
                    } else {
                        $usage = $list_future;
                    }

                    for (obj in maintenance.objects) {
                        if (maintenance.objects.hasOwnProperty(obj)) {
                            $object = $usage.down('[data-object-id="' + maintenance.objects[obj] + '"]');

                            if (!$object) {
                                $usage.store('count', $usage.retrieve('count') + 1);

                                if (($usage.retrieve('count') * 255) > list_width) {
                                    $usage.store('count', 1).insert(new Element('div', {className: 'cb'}));
                                }

                                $object = object_elements[maintenance.objects[obj]].clone(true);
                                $usage.insert($object);
                            }

                            $object_ul = $object.down('ul');

                            $object_ul.insert(
                                new Element('li', {className: 'mt10'})
                                    .update(new Element('img', {className: 'vam mr5', src: '[{$dir_images}]axialis/basic/tool-wrench.svg'}))
                                    .insert(new Element('a', {href: '[{$planning_url}]&[{$smarty.const.C__GET__ID}]=' + maintenance.isys_maintenance__id})
                                        .update(maintenance.dates[date].fromFormatted + ' - ' + maintenance.dates[date].toFormatted)));

                            // Now add each person, persongroup, organisation and role.
                            for (j in maintenance.contacts) {
                                if (maintenance.contacts.hasOwnProperty(j)) {
                                    $object_ul.insert(
                                        new Element('li')
                                            .update(new Element('img', {className: 'vam mr5', src: maintenance.contacts[j].isys_obj_type__icon}))
                                            .insert(new Element('a', {href: '?[{$smarty.const.C__CMDB__GET__OBJECT}]=' + maintenance.contacts[j].isys_obj__id})
                                                .update(maintenance.contacts[j].isys_obj_type__title + ' &raquo; ' + maintenance.contacts[j].isys_obj__title)));
                                }
                            }

                            role_people = '';

                            if (objects[maintenance.objects[obj]]['roles'].hasOwnProperty(maintenance.isys_maintenance__isys_contact_tag__id)) {
                                role_people = objects[maintenance.objects[obj]]['roles'][maintenance.isys_maintenance__isys_contact_tag__id];
                            }

                            if (Object.isArray(role_people)) {
                                role_people = role_people.join(', ');
                            }

                            $object_ul.insert(new Element('li')
                                .update(new Element('strong', {className: 'mr10'}).update('[{isys type="lang" ident="LC__CMDB__CONTACT_ROLE"}]'))
                                .insert(new Element('span', {
                                    className: (!role_people.empty() ? 'mouse-help underline' : ''),
                                    title:     role_people
                                }).update(maintenance.isys_contact_tag__title.join(', ') || '[{isys_tenantsettings::get('gui.empty_value', '-')}]')));
                        }
                    }
                }
            }

			// Hide the empty timeperiods (+ headlines).
			$list.select('.timeperiod:not(:empty)').invoke('show')
				.invoke('previous').invoke('show');
		}

		$list.select('.timeperiod:empty').invoke('hide')
			.invoke('previous').invoke('hide');
	})();
</script>
