[{isys_group name="tom.popup.maintenance"}]
    <div id="maintenance-popup-finish-maintenance">
        <div class="popup-header-ng">
            <h1>[{isys type="lang" ident="LC__MAINTENANCE__POPUP__FINISH_MAINTENANCE"}]</h1>
            <button type="button" class="btn btn-secondary popup-closer ml-auto" title="[{isys type="lang" ident="LC__POPUP__CLOSE"}]" data-tooltip="1">
                <img alt="close" src="[{$dir_images}]axialis/user-interface/window-control-close.svg" />
            </button>
        </div>

        <div class="popup-content" style="height:432px;">
            <table class="contentTable" cellspacing="0" cellpadding="0">
                <tr>
                    <td class="key vat">[{isys type="lang" ident="LC__MAINTENANCE__POPUP__MAINTENANCES_TO_FINISH"}]</td>
                    <td class="value">
                        <ul id="maintenance-popup-unfinished" class="m0 ml20 list-style-none"></ul>
                    </td>
                </tr>
                <tr>
                    <td class="key vat">[{isys type="f_label" name="C__MAINTENANCE__POPUP__FINISH_COMMENT" ident="LC__MAINTENANCE__POPUP__FINISH_COMMENT"}]</td>
                    <td class="value">[{isys type="f_wysiwyg" name="C__MAINTENANCE__POPUP__FINISH_COMMENT"}]</td>
                </tr>
            </table>
        </div>

        <div class="popup-footer-ng">
            <button id="maintenance-popup-button-finish-maintenance" type="button" class="btn mr5">
                <img src="[{$dir_images}]axialis/basic/symbol-ok.svg"><span>[{isys type="lang" ident="LC__MAINTENANCE__POPUP__FINISH_MAINTENANCE"}]</span>
            </button>
            <button type="button" class="btn popup-closer">
                <img src="[{$dir_images}]axialis/basic/symbol-cancel.svg"><span>[{isys type="lang" ident="LC_UNIVERSAL__ABORT"}]</span>
            </button>
        </div>
    </div>
    <style type="text/css">
        #maintenance-popup-finish-maintenance .key {
            width: 150px;
        }
    </style>
    <script type="text/javascript">
        (function () {
            'use strict';

            var $popup            = $('maintenance-popup-finish-maintenance'),
                $popup_content    = $popup.down('.popup-content'),
                $comment          = $('C__MAINTENANCE__POPUP__FINISH_COMMENT'),
                $finish_button    = $('maintenance-popup-button-finish-maintenance'),
                $maintenance_id   = $('C__MAINTENANCE__PLANNING__ID'),
                $maintenance_list = $('maintenance-list'),
                $unfinished       = $('maintenance-popup-unfinished'),
                ids               = [],
                id;

            $popup.on('click', '.popup-closer', function () {
                popup_close();
            });

            $finish_button.on('click', function () {
                var last_error = false;

                new Ajax.Request('[{$ajax_url}]&func=finish-maintenances', {
                    parameters: {
                        ids:     Object.toJSON(ids),
                        comment: $comment.getValue()
                    },
                    onSuccess:  function (response) {
                        var json = response.responseJSON, i;

                        if (json.success) {
                            for (i in json.data) {
                                if (json.data.hasOwnProperty(i) && json.data[i] !== true) {
                                    $unfinished.down('li[data-maintenance-id="' + i + '"]')
                                        .insert(new Element('img', {className: 'ml20 vam mr5', src: window.dir_images + 'axialis/basic/warning.svg'}))
                                        .insert(new Element('span', {className: 'text-red'}).update(json.data[i]));

                                    last_error = json.data[i];
                                } else {
                                    $unfinished.down('li[data-maintenance-id="' + i + '"]')
                                        .insert(new Element('img', {className: 'ml20 vam', src: '[{$dir_images}]axialis/basic/symbol-ok.svg'}));
                                }
                            }
                        } else {
                            last_error = json.message || response.responseText;
                        }
                    },
                    onFailure:  function (response) {
                        last_error = response.responseText;
                    },
                    onComplete: function () {
                        if (last_error) {
                            idoit.Notify.error(last_error, {sticky: true});
                        } else {
                            idoit.Notify.success('[{isys type="lang" ident="LC__MAINTENANCE__NOTIFY__COMPLETED_SUCCESSFULLY"}]', {sticky: true});

                            document.location.reload(true);
                        }
                    }
                });
            });

            if ($maintenance_id) {
                id = parseInt($maintenance_id.getValue());

                ids.push(id);

                $unfinished.insert(new Element('li', {'data-maintenance-id': id}).update($('C__MAINTENANCE__PLANNING__TYPE').down(':selected').innerHTML + ' (#' + id + ')'));
            } else if ($maintenance_list) {
                $maintenance_list.down('.table-container .table-body').select('input:checked').each(function ($checkbox) {
                    id = parseInt($checkbox.getValue());

                    $unfinished.insert(new Element('li', {'data-maintenance-id': id}).update($checkbox.up('tr').down('td', 2).innerHTML + ' (#' + id + ')'));
                    ids.push(id);
                });
            }

            if (ids.length === 0) {
                $finish_button.disable();

                $popup_content.update(new Element('p', {className: 'p5 m5 text-yellow'})
                    .update(new Element('img', {src: window.dir_images + 'axialis/basic/warning.svg', className: 'vam mr5'}))
                    .insert(new Element('span').update('[{isys type="lang" ident="LC__MAINTENANCE__POPUP__NO_MAINTENANCES_SELECTED"}]')));
            }
        })();
    </script>
[{/isys_group}]
