<?php

/**
 * i-doit
 *
 * Maintenance category UI.
 *
 * @package     modules
 * @subpackage  maintenance
 * @version     1.0.1
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.5.1
 */
class isys_cmdb_ui_category_g_virtual_maintenance extends isys_cmdb_ui_category_g_virtual
{
    /**
     * Process method.
     *
     * @param isys_cmdb_dao_category_g_virtual_maintenance $dao
     *
     * @return  array|void
     */
    public function process(isys_cmdb_dao_category $dao)
    {
        isys_component_template_navbar::getInstance()->deactivate_all_buttons();

        $filterAscending = $_GET['filter'] === 'ASC';
        $result = $dao->getMaintenancesByObject((int)$_GET[C__CMDB__GET__OBJECT], $filterAscending);
        $maintenances = [];

        if (count($result)) {
            $locales = isys_application::instance()->container->get('locales');

            while ($row = $result->get_row()) {
                $item = [
                    'from'               => $locales->fmt_datetime($row['isys_maintenance__date_from']),
                    'to'                 => $locales->fmt_datetime($row['isys_maintenance__date_to']),
                    'finished'           => (bool)$row['isys_maintenance__finished'],
                    'finished_datetime'  => $locales->fmt_datetime($row['isys_maintenance__finished']),
                    'mail_sent'          => (bool)$row['isys_maintenance__mail_dispatched'],
                    'mail_sent_datetime' => $locales->fmt_datetime($row['isys_maintenance__mail_dispatched']),
                    'url'                => isys_helper_link::create_url([
                        C__GET__MODULE_ID     => C__MODULE__MAINTENANCE,
                        C__GET__TREE_NODE     => C__MODULE__MAINTENANCE . 2,
                        C__GET__SETTINGS_PAGE => C__MAINTENANCE__PLANNING,
                        C__GET__ID            => $row['isys_maintenance__id']
                    ])
                ];

                if ($item['finished']) {
                    $item['url'] = isys_helper_link::create_url([
                        C__GET__MODULE_ID     => C__MODULE__MAINTENANCE,
                        C__GET__TREE_NODE     => C__MODULE__MAINTENANCE . 3,
                        C__GET__SETTINGS_PAGE => C__MAINTENANCE__PLANNING_ARCHIVE,
                        C__GET__ID            => $row['isys_maintenance__id']
                    ]);
                }

                $maintenances[] = $item;
            }
        }

        $filterUrl = [
            C__CMDB__GET__OBJECT => $_GET[C__CMDB__GET__OBJECT],
            C__CMDB__GET__CATG   => C__CATG__VIRTUAL_MAINTENANCE,
            'filter'             => $filterAscending ? 'DESC' : 'ASC'
        ];

        $this->deactivate_commentary()
            ->get_template_component()
            ->assign('filter_asc', $filterAscending)
            ->assign('filter_url', isys_helper_link::create_url($filterUrl))
            ->assign('maintenances', $maintenances)
            ->include_template('contentbottomcontent', isys_module_maintenance::getPath() . 'templates/cmdb/catg__virtual_maintenance.tpl');
    }
}
