<?php

use idoit\Console\IdoitConsoleApplication;
use idoit\Module\Nagios\Console\Command\NagiosCommand;
use Symfony\Component\Console\Input\ArrayInput;
use Symfony\Component\Console\Output\ConsoleOutput;

/**
 * i-doit
 *
 * Nagios handler.
 *
 * @package     i-doit
 * @subpackage  General
 * @author      Dennis Bluemer <dbluemer@i.doit.org>
 * @version     0.9.3
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_handler_nagios extends isys_handler
{
    /**
     * @return  boolean
     */
    public function init()
    {
        $session = isys_application::instance()->container->get('session');

        if ($session->is_logged_in()) {
            $application = new IdoitConsoleApplication();
            $application->setAutoExit(false);

            $output = new ConsoleOutput();

            $output->writeln('<error>isys_handler_nagios is deprecated, please use php console.php nagios-statusupdate instead</error>');

            $commandParams = [
                'command'    => 'nagios-statusupdate',
                '--user'     => 'loginBefore',
                '--password' => 'loginBefore',
                '--tenantId' => 'loginBefore'
            ];

            /**
             * @var $command \idoit\Console\Command\AbstractCommand
             */
            $command = new NagiosCommand();
            $command->setSession($session);
            $command->setContainer(\isys_application::instance()->container);
            $command->setAuth(\isys_auth_system::instance());

            $application->add($command);

            $application->run(new ArrayInput($commandParams), $output);
        }

        return true;
    }
}
