<?php

/**
 * i-doit
 *
 * CMDB Person: Specific category
 *
 * @package     i-doit
 * @subpackage  CMDB_Categories
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_cmdb_ui_category_s_person_nagios extends isys_cmdb_ui_category_specific
{
    /**
     * Process method.
     *
     * @param   isys_cmdb_dao_category_s_person_nagios $p_cat
     *
     * @global  array                                  $index_includes
     */
    public function process(isys_cmdb_dao_category $p_cat)
    {
        $l_rules = [];

        isys_component_template_navbar::getInstance()
            ->set_active(false, C__NAVBAR_BUTTON__NEW);

        isys_nagios_helper::init();

        $l_catdata = $p_cat->get_general_data();

        $l_comp_daoNagios = isys_component_dao_nagios::instance($p_cat->get_database_component());

        $this->fill_formfields($p_cat, $l_rules, $l_catdata);

        // // @see NAGIOS-34 Move some definitions to different constants (for the UI to work with multiselection).
        $l_rules["HOST_NOTIFICATION_OPTIONS[]"] = $l_rules["HOST_NOTIFICATION_OPTIONS"];
        $l_rules["SERVICE_NOTIFICATION_OPTIONS[]"] = $l_rules["SERVICE_NOTIFICATION_OPTIONS"];
        $l_rules["CONTACT_HOST_NOTIFICATION_COMMANDS[]"] = $l_rules["CONTACT_HOST_NOTIFICATION_COMMANDS"];
        $l_rules["CONTACT_SERVICE_NOTIFICATION_COMMANDS[]"] = $l_rules["CONTACT_SERVICE_NOTIFICATION_COMMANDS"];

        if ($l_catdata == null) {
            $l_rules["CONTACT_NAGIOS_IS_EXPORTABLE"]["p_strSelectedID"] = 1;
            $l_catdata['isys_cats_person_nagios_list__isys_obj__id'] = $_GET[C__CMDB__GET__OBJECT];
        }

        // Apply rules.
        $this->get_template_component()
            ->assign('contact_name_selection', $l_catdata['isys_cats_person_nagios_list__contact_name_selection'] ?: C__NAGIOS__PERSON_OPTION__OBJECT_TITLE)
            ->assign('obj_title', isys_cmdb_dao::instance($this->m_database_component)
                ->get_obj_name_by_id_as_string($l_catdata['isys_cats_person_nagios_list__isys_obj__id']))
            ->assign('user_name', isys_cmdb_dao_category_s_person_login::instance($this->m_database_component)
                ->get_data(null, $l_catdata['isys_cats_person_nagios_list__isys_obj__id'])
                ->get_row_value('isys_cats_person_list__title'))
            ->assign('contact_name',
                isys_nagios_helper::prepare_valid_name(isys_nagios_helper::get_correct_contact_name($l_catdata['isys_cats_person_nagios_list__isys_obj__id'])))
            ->smarty_tom_add_rules("tom.content.bottom.content", $l_rules);
    }

    public function get_template()
    {
        return isys_module_nagios::getPath() . 'templates/cmdb/cats__person_nagios.tpl';
    }
}
