<?php

use idoit\Module\Cmdb\Interfaces\ObjectBrowserReceiver;

/**
 * i-doit
 *
 * DAO: global category for Nagios.
 *
 * @package     i-doit
 * @subpackage  CMDB_Categories
 * @author      Leonard Fischer <lfischer@i-doit.<com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_cmdb_dao_category_g_nagios_refs_services_backwards extends isys_cmdb_dao_category_global implements ObjectBrowserReceiver
{
    /**
     * Category's name. Will be used for the identifier, constant, main table, and many more.
     *
     * @var  string
     */
    protected $m_category = 'nagios_refs_services_backwards';

    /**
     * @var string
     */
    protected $m_connected_object_id_field = 'isys_catg_nagios_refs_services_list__isys_obj__id__host';

    /**
     * @var bool
     */
    protected $m_has_relation = true;

    /**
     * Flag which defines if the category is only a list with an object browser
     *
     * @var bool
     */
    protected $m_object_browser_category = true;

    /**
     * Property of the object browser
     *
     * @var string
     */
    protected $m_object_browser_property = 'assigned_objects';

    /**
     * @var string
     */
    protected $m_object_id_field = 'isys_catg_nagios_refs_services_list__isys_obj__id__service';

    /**
     * @var string
     */
    protected $m_table = 'isys_catg_nagios_refs_services_list';

    /**
     * @param int   $p_object_id
     * @param array $p_objects
     *
     * @return mixed|null
     * @throws Exception
     */
    public function attachObjects($p_object_id, array $p_objects)
    {
        $l_id = null;
        $l_delete_data = $l_data = $this->get_selected_objects($p_object_id, true);

        foreach ($l_data as $l_data_key => $l_obj_id) {
            if (($l_key = array_search($l_obj_id, $p_objects)) !== false) {
                unset($p_objects[$l_key], $l_delete_data[$l_data_key]);
            }
        }

        if (count($l_delete_data) > 0) {
            $this->delete_entry(array_keys($l_delete_data), 'isys_catg_nagios_refs_services_list');
        }

        if (count($p_objects) > 0) {
            foreach ($p_objects as $l_obj_id) {
                $l_id = $this->create($p_object_id, $l_obj_id);
            }
        }

        return $l_id;
    }

    /**
     * Executes the query to create the category entry.
     *
     * @param   integer $p_object_id
     * @param   integer $p_connected_obj
     *
     * @return  mixed  Integer with the newly created ID or boolean false on failure.
     * @author  Van Quyen Hoang <qhoang@i-doit.com>
     */
    public function create($p_object_id, $p_connected_obj)
    {
        $l_dao_rel = new isys_cmdb_dao_category_g_relation($this->get_database_component());

        $l_sql = 'INSERT INTO isys_catg_nagios_refs_services_list
			SET isys_catg_nagios_refs_services_list__isys_obj__id__host = ' . $this->convert_sql_id($p_connected_obj) . ',
			isys_catg_nagios_refs_services_list__isys_obj__id__service = ' . $this->convert_sql_id($p_object_id) . ';';

        $l_last_id = false;

        if ($this->update($l_sql) && $this->apply_update()) {
            $l_last_id = $this->get_last_insert_id();

            $l_dao_rel->handle_relation($l_last_id, 'isys_catg_nagios_refs_services_list', C__RELATION_TYPE__NAGIOS_REFS_SERVICE, null, $p_connected_obj, $p_object_id);
        }

        return $l_last_id;
    }

    /**
     * Count method, for the navigation tree.
     *
     * @param   integer $p_obj_id
     *
     * @return  integer
     */
    public function get_count($p_obj_id = null)
    {
        $l_obj_id = $this->m_object_id;

        if ($p_obj_id !== null) {
            $l_obj_id = $p_obj_id;
        }

        $l_sql = 'SELECT count(isys_catg_nagios_refs_services_list__isys_obj__id__service) AS count
			FROM isys_catg_nagios_refs_services_list
			WHERE TRUE ';

        if ($l_obj_id > 0) {
            $l_sql .= 'AND isys_catg_nagios_refs_services_list__isys_obj__id__service = ' . $this->convert_sql_id($p_obj_id);
        }

        return (int)current($this->retrieve($l_sql . ';')
            ->get_row());
    }

    /**
     * get_data method.
     *
     * @param   integer $p_catg_list_id
     * @param   integer $p_obj_id
     * @param   string  $p_condition
     * @param   mixed   $p_filter
     * @param   integer $p_status
     *
     * @return  isys_component_dao_result
     */
    public function get_data($p_catg_list_id = null, $p_obj_id = null, $p_condition = '', $p_filter = null, $p_status = null)
    {
        $l_sql = 'SELECT * FROM isys_catg_nagios_refs_services_list
			INNER JOIN isys_obj ON isys_obj__id = isys_catg_nagios_refs_services_list__isys_obj__id__host
			WHERE TRUE ' . $p_condition . ' ' . $this->prepare_filter($p_filter);

        if ($p_catg_list_id !== null) {
            $l_sql .= ' AND isys_catg_nagios_refs_services_list__id = ' . $this->convert_sql_id($p_catg_list_id);
        }

        if ($p_obj_id !== null) {
            $l_sql .= ' AND isys_catg_nagios_refs_services_list__isys_obj__id__service = ' . $this->convert_sql_id($p_obj_id);
        }

        return $this->retrieve($l_sql . ';');
    }

    /**
     * Method for returning the properties.
     *
     * @return  array
     * @author  Van Quyen Hoang <qhoang@i-doit.com>
     */
    protected function properties()
    {
        return [
            'assigned_objects' => array_replace_recursive(isys_cmdb_dao_category_pattern::object_browser(), [
                C__PROPERTY__INFO     => [
                    C__PROPERTY__INFO__TITLE       => 'LC__CATG__NAGIOS_HOST_TPL_ASSIGNED_OBJECTS',
                    C__PROPERTY__INFO__DESCRIPTION => 'Assigned objects'
                ],
                C__PROPERTY__DATA     => [
                    C__PROPERTY__DATA__FIELD            => 'isys_catg_nagios_refs_services_list__isys_obj__id__host',
                    C__PROPERTY__DATA__RELATION_TYPE    => C__RELATION_TYPE__NAGIOS_REFS_SERVICE,
                    C__PROPERTY__DATA__RELATION_HANDLER => new isys_callback([
                        'isys_cmdb_dao_category_g_nagios_refs_services_backwards',
                        'callback_property_relation_handler'
                    ], [
                        'isys_cmdb_dao_category_g_nagios_refs_services_backwards',
                        true
                    ]),
                    C__PROPERTY__DATA__SELECT           => idoit\Module\Report\SqlQuery\Structure\SelectSubSelect::factory('SELECT CONCAT(isys_obj__title, \' {\', isys_obj__id, \'}\')
                              FROM isys_catg_nagios_refs_services_list
                              INNER JOIN isys_obj ON isys_obj__id = isys_catg_nagios_refs_services_list__isys_obj__id__host', 'isys_catg_nagios_refs_services_list',
                        'isys_catg_nagios_refs_services_list__id', 'isys_catg_nagios_refs_services_list__isys_obj__id__service'),
                    C__PROPERTY__DATA__JOIN             => [
                        idoit\Module\Report\SqlQuery\Structure\SelectJoin::factory('isys_catg_nagios_refs_services_list', 'LEFT',
                            'isys_catg_nagios_refs_services_list__isys_obj__id__service', 'isys_obj__id'),
                        idoit\Module\Report\SqlQuery\Structure\SelectJoin::factory('isys_obj', 'LEFT', 'isys_catg_nagios_refs_services_list__isys_obj__id__host',
                            'isys_obj__id')
                    ]
                ],
                C__PROPERTY__UI       => [
                    C__PROPERTY__UI__ID => 'C__CATG__NAGIOS_ASSIGNED_SERVICES'
                ],
                C__PROPERTY__PROVIDES => [
                    C__PROPERTY__PROVIDES__LIST   => false,
                    C__PROPERTY__PROVIDES__SEARCH => false,
                    C__PROPERTY__PROVIDES__IMPORT => false,
                    C__PROPERTY__PROVIDES__EXPORT => false
                ]
            ])
        ];
    }

    /**
     * Gets assigned nagios services for object browser
     *
     * @param      $p_obj_id
     * @param bool $p_as_array
     *
     * @return array|isys_component_dao_result
     */
    public function get_selected_objects($p_obj_id, $p_as_array = false)
    {
        $l_sql = 'SELECT isys_obj.*, isys_catg_nagios_refs_services_list__id
			FROM isys_catg_nagios_refs_services_list
			INNER JOIN isys_obj ON isys_obj__id = isys_catg_nagios_refs_services_list__isys_obj__id__host
			WHERE isys_catg_nagios_refs_services_list__isys_obj__id__service = ' . $this->convert_sql_id($p_obj_id) . '
			AND isys_obj__status = ' . $this->convert_sql_int(C__RECORD_STATUS__NORMAL) . ';';

        if ($p_as_array) {
            $l_res = $this->retrieve($l_sql);
            $l_data = [];

            while ($l_row = $l_res->get_row()) {
                $l_data[$l_row['isys_catg_nagios_refs_services_list__id']] = $l_row['isys_obj__id'];
            }

            return $l_data;
        } else {
            return $this->retrieve($l_sql);
        }
    }

    /**
     * Rank records method
     *
     * @param        $nagiosObjectIds
     * @param int    $p_direction
     * @param string $p_table
     * @param null   $p_checkMethod
     * @param bool   $p_purge
     *
     * @return  bool
     * @throws isys_exception_database
     * @author  Van Quyen Hoang <qhoang@i-doit.com>
     */
    public function rank_records($nagiosObjectIds, $p_direction = C__CMDB__RANK__DIRECTION_DELETE, $p_table = "isys_obj", $p_checkMethod = null, $p_purge = false)
    {
        switch ($_POST[C__GET__NAVMODE]) {
            case C__NAVMODE__QUICK_PURGE:
            case C__NAVMODE__PURGE:
                if (!empty($nagiosObjectIds)) {
                    $result = $this->get_data(null, $_GET[C__CMDB__GET__OBJECT]);
                    $catIdsToDelete = $beforeDelete = $afterDelete = $changes = [];
                    while ($dataSet = $result->get_row()) {
                        if ($dataSet['isys_obj__status'] != C__RECORD_STATUS__NORMAL) {
                            continue;
                        }

                        $assignedObject = $dataSet['isys_catg_nagios_refs_services_list__isys_obj__id__host'];
                        $catId = $dataSet['isys_catg_nagios_refs_services_list__id'];
                        $nagiosServiceTitle = $dataSet['isys_obj__title'];
                        $beforeDelete[$assignedObject] = $nagiosServiceTitle;

                        if (in_array($assignedObject, $nagiosObjectIds)) {
                            $catIdsToDelete[$catId] = $dataSet;
                        } else {
                            $afterDelete[$assignedObject] = $nagiosServiceTitle;
                        }
                    }

                    $this->m_strLogbookSQL = "DELETE FROM isys_catg_nagios_refs_services_list WHERE isys_catg_nagios_refs_services_list__id IN (" .
                        implode(',', array_keys($afterDelete)) . ");";
                    $this->delete_entry(array_keys($catIdsToDelete), 'isys_catg_nagios_refs_services_list');

                    $changes['isys_cmdb_dao_category_g_nagios_refs_services_backwards::assigned_objects'] = [
                        'from' => implode(', ', $beforeDelete),
                        'to'   => implode(', ', $afterDelete)
                    ];

                    isys_event_manager::getInstance()
                        ->triggerCMDBEvent("C__LOGBOOK_EVENT__CATEGORY_PURGED", $this->m_strLogbookSQL, $_GET[C__CMDB__GET__OBJECT],
                            $this->get_objTypeID($_GET[C__CMDB__GET__OBJECT]), 'LC__CATG__NAGIOS_REFS_SERVICES_BACKWARDS', serialize($changes));
                }
                break;
        }

        return true;
    }
}
