<?php

/**
 * i-doit
 *
 * DAO: specific category for Nagios related persons.
 *
 * @package     i-doit
 * @subpackage  CMDB_Categories
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_cmdb_dao_category_s_person_nagios extends isys_cmdb_dao_category_specific
{
    /**
     * Category's name. Will be used for the identifier, constant, main table, and many more.
     *
     * @var  string
     */
    protected $m_category = 'person_nagios';

    /**
     * Get data method.
     *
     * @param   integer $p_cats_list_id
     * @param   mixed   $p_obj_id
     * @param   string  $p_condition
     * @param   mixed   $p_filter
     * @param   integer $p_status
     *
     * @return  isys_component_dao_result
     */
    public function get_data($p_cats_list_id = null, $p_obj_id = null, $p_condition = "", $p_filter = null, $p_status = null)
    {
        $l_sql = 'SELECT *
			FROM isys_cats_person_nagios_list
			WHERE TRUE ' . $p_condition . $this->prepare_filter($p_filter);

        if ($p_obj_id !== null) {
            $l_sql .= $this->get_object_condition($p_obj_id);
        }

        if ($p_cats_list_id !== null) {
            $l_sql .= ' AND isys_cats_person_nagios_list__id = ' . $this->convert_sql_id($p_cats_list_id);
        }

        if ($p_status !== null) {
            $l_sql .= ' AND isys_cats_person_nagios_list__status = ' . $this->convert_sql_int($p_status);
        }

        return $this->retrieve($l_sql . ';');
    }

    /**
     * Creates the condition to the object table.
     *
     * @param   mixed $p_obj_id May be an integer or an array of integers.
     *
     * @return  string
     * @author  Van Quyen Hoang <qhoang@i-doit.de>
     */
    public function get_object_condition($p_obj_id = null, $p_alias = 'isys_obj')
    {
        if (!empty($p_obj_id)) {
            if (is_array($p_obj_id)) {
                return ' AND isys_cats_person_nagios_list__isys_obj__id ' . $this->prepare_in_condition($p_obj_id);
            } else {
                return ' AND isys_cats_person_nagios_list__isys_obj__id = ' . $this->convert_sql_id($p_obj_id);
            }
        }

        return '';
    }

    /**
     * Method for returning the properties.
     *
     * @return  array
     */
    protected function properties()
    {
        $l_dialog_yes_no = get_smarty_arr_YES_NO();

        return [
            'alias'                            => array_replace_recursive(isys_cmdb_dao_category_pattern::text(), [
                C__PROPERTY__INFO => [
                    C__PROPERTY__INFO__TITLE       => 'LC__CMDB__CATG__NAGIOS_LIST_ALIAS',
                    C__PROPERTY__INFO__DESCRIPTION => 'Alias'
                ],
                C__PROPERTY__DATA => [
                    C__PROPERTY__DATA__FIELD => 'isys_cats_person_nagios_list__alias'
                ],
                C__PROPERTY__UI   => [
                    C__PROPERTY__UI__ID => 'CONTACT_ALIAS'
                ]
            ]),
            'contact_name'                     => array_replace_recursive(isys_cmdb_dao_category_pattern::text(), [
                C__PROPERTY__INFO     => [
                    C__PROPERTY__INFO__TITLE       => 'contact_name',
                    C__PROPERTY__INFO__DESCRIPTION => 'contact_name'
                ],
                C__PROPERTY__DATA     => [
                    C__PROPERTY__DATA__FIELD  => 'isys_cats_person_nagios_list__contact_name',
                    C__PROPERTY__DATA__SELECT => idoit\Module\Report\SqlQuery\Structure\SelectSubSelect::factory('SELECT (CASE
                                WHEN isys_cats_person_nagios_list__contact_name_selection = ' . C__NAGIOS__PERSON_OPTION__OBJECT_TITLE . ' THEN isys_obj__title
                                WHEN isys_cats_person_nagios_list__contact_name_selection = ' . C__NAGIOS__PERSON_OPTION__USERNAME . ' THEN isys_cats_person_list__title
                                WHEN isys_cats_person_nagios_list__contact_name_selection = ' . C__NAGIOS__PERSON_OPTION__INPUT . ' THEN isys_cats_person_nagios_list__contact_name
                             END)
                            FROM isys_cats_person_nagios_list
                            INNER JOIN isys_cats_person_list ON isys_cats_person_list__isys_obj__id = isys_cats_person_nagios_list__isys_obj__id
                            INNER JOIN isys_obj ON isys_obj__id = isys_cats_person_nagios_list__isys_obj__id', 'isys_cats_person_nagios_list',
                        'isys_cats_person_nagios_list__id', 'isys_cats_person_nagios_list__isys_obj__id')
                ],
                C__PROPERTY__UI       => [
                    C__PROPERTY__UI__ID     => 'CONTACT_NAME',
                    C__PROPERTY__UI__PARAMS => [
                        'p_bInfoIconSpacer' => 0,
                        'disableInputGroup' => true
                    ]
                ],
                C__PROPERTY__PROVIDES => [
                    C__PROPERTY__PROVIDES__VIRTUAL => true
                ]
            ]),
            'contact_name_selection'           => array_replace_recursive(isys_cmdb_dao_category_pattern::int(), [
                C__PROPERTY__INFO     => [
                    C__PROPERTY__INFO__TITLE       => 'contact_name selection',
                    C__PROPERTY__INFO__DESCRIPTION => 'contact_name selection'
                ],
                C__PROPERTY__DATA     => [
                    C__PROPERTY__DATA__FIELD => 'isys_cats_person_nagios_list__contact_name_selection'
                ],
                C__PROPERTY__UI       => [
                    C__PROPERTY__UI__ID => 'CONTACT_NAME_SELECTION'
                ],
                C__PROPERTY__PROVIDES => [
                    C__PROPERTY__PROVIDES__LIST   => false,
                    C__PROPERTY__PROVIDES__REPORT => false,
                    C__PROPERTY__PROVIDES__IMPORT => true,
                    C__PROPERTY__PROVIDES__EXPORT => true
                ]
            ]),
            'host_notification_enabled'        => array_replace_recursive(isys_cmdb_dao_category_pattern::dialog(), [
                C__PROPERTY__INFO     => [
                    C__PROPERTY__INFO__TITLE       => 'host_notification_enabled',
                    C__PROPERTY__INFO__DESCRIPTION => 'host_notification_enabled'
                ],
                C__PROPERTY__DATA     => [
                    C__PROPERTY__DATA__FIELD  => 'isys_cats_person_nagios_list__host_notification_enabled',
                    C__PROPERTY__DATA__SELECT => idoit\Module\Report\SqlQuery\Structure\SelectSubSelect::factory('(CASE
                                    WHEN isys_cats_person_nagios_list__host_notification_enabled = \'1\' THEN ' . $this->convert_sql_text('LC__UNIVERSAL__YES') . '
                                    WHEN isys_cats_person_nagios_list__host_notification_enabled = \'0\' THEN ' . $this->convert_sql_text('LC__UNIVERSAL__NO') . '
                                    END)', 'isys_cats_person_nagios_list'),
                    C__PROPERTY__DATA__JOIN   => [
                        idoit\Module\Report\SqlQuery\Structure\SelectJoin::factory('isys_cats_person_nagios_list', 'LEFT', 'isys_cats_person_nagios_list__isys_obj__id',
                            'isys_obj__id')
                    ]
                ],
                C__PROPERTY__UI       => [
                    C__PROPERTY__UI__ID     => 'CONTACT_HOST_NOTIFICATION',
                    C__PROPERTY__UI__PARAMS => [
                        'p_arData' => $l_dialog_yes_no
                    ]
                ],
                C__PROPERTY__PROVIDES => [
                    C__PROPERTY__PROVIDES__SEARCH => false,
                    C__PROPERTY__PROVIDES__SEARCH_INDEX => false,
                ],
                C__PROPERTY__FORMAT   => [
                    C__PROPERTY__FORMAT__CALLBACK => [
                        'isys_export_helper',
                        'get_yes_or_no'
                    ]
                ]
            ]),
            'service_notification_enabled'     => array_replace_recursive(isys_cmdb_dao_category_pattern::dialog(), [
                C__PROPERTY__INFO     => [
                    C__PROPERTY__INFO__TITLE       => 'service_notification_enabled',
                    C__PROPERTY__INFO__DESCRIPTION => 'service_notification_enabled'
                ],
                C__PROPERTY__DATA     => [
                    C__PROPERTY__DATA__FIELD  => 'isys_cats_person_nagios_list__service_notification_enabled',
                    C__PROPERTY__DATA__SELECT => idoit\Module\Report\SqlQuery\Structure\SelectSubSelect::factory('(CASE
                                    WHEN isys_cats_person_nagios_list__service_notification_enabled = \'1\' THEN ' . $this->convert_sql_text('LC__UNIVERSAL__YES') . '
                                    WHEN isys_cats_person_nagios_list__service_notification_enabled = \'0\' THEN ' . $this->convert_sql_text('LC__UNIVERSAL__NO') . '
                                    END)', 'isys_cats_person_nagios_list'),
                    C__PROPERTY__DATA__JOIN   => [
                        idoit\Module\Report\SqlQuery\Structure\SelectJoin::factory('isys_cats_person_nagios_list', 'LEFT', 'isys_cats_person_nagios_list__isys_obj__id',
                            'isys_obj__id')
                    ]
                ],
                C__PROPERTY__UI       => [
                    C__PROPERTY__UI__ID     => 'CONTACT_SERVICE_NOTIFICATION',
                    C__PROPERTY__UI__PARAMS => [
                        'p_arData' => $l_dialog_yes_no
                    ]
                ],
                C__PROPERTY__PROVIDES => [
                    C__PROPERTY__PROVIDES__SEARCH => false,
                    C__PROPERTY__PROVIDES__SEARCH_INDEX => false,
                ],
                C__PROPERTY__FORMAT   => [
                    C__PROPERTY__FORMAT__CALLBACK => [
                        'isys_export_helper',
                        'get_yes_or_no'
                    ]
                ]
            ]),
            'host_notification_period'         => array_replace_recursive(isys_cmdb_dao_category_pattern::dialog(), [
                C__PROPERTY__INFO   => [
                    C__PROPERTY__INFO__TITLE       => 'host_notification_period',
                    C__PROPERTY__INFO__DESCRIPTION => 'host_notification_period'
                ],
                C__PROPERTY__DATA   => [
                    C__PROPERTY__DATA__INDEX => false,
                    C__PROPERTY__DATA__SOURCE_TABLE => 'isys_nagios_timeperiods',
                    C__PROPERTY__DATA__FIELD  => 'isys_cats_person_nagios_list__host_notification_period',
                    C__PROPERTY__DATA__SELECT => idoit\Module\Report\SqlQuery\Structure\SelectSubSelect::factory('SELECT isys_nagios_timeperiods__name
                            FROM isys_cats_person_nagios_list
                            INNER JOIN isys_nagios_timeperiods ON isys_nagios_timeperiods__id = isys_cats_person_nagios_list__host_notification_period',
                        'isys_cats_person_nagios_list', 'isys_cats_person_nagios_list__id', 'isys_cats_person_nagios_list__isys_obj__id'),
                    C__PROPERTY__DATA__JOIN   => [
                        idoit\Module\Report\SqlQuery\Structure\SelectJoin::factory('isys_cats_person_nagios_list', 'LEFT', 'isys_cats_person_nagios_list__isys_obj__id',
                            'isys_obj__id'),
                        idoit\Module\Report\SqlQuery\Structure\SelectJoin::factory('isys_nagios_timeperiods', 'LEFT', 'isys_cats_person_nagios_list__host_notification_period',
                            'isys_nagios_timeperiods__id')
                    ]
                ],
                C__PROPERTY__UI     => [
                    C__PROPERTY__UI__ID     => 'CONTACT_HOST_NOTIFICATION_PERIOD',
                    C__PROPERTY__UI__PARAMS => [
                        'p_arData'          => new isys_callback([
                            'isys_cmdb_dao_category_g_nagios',
                            'callback_property_general_dialog_nagios_methods'
                        ], ['getTimeperiodsAssoc']),
                        'disableInputGroup' => true,
                        'p_bInfoIconSpacer' => 0
                    ]
                ],
                C__PROPERTY__FORMAT => [
                    C__PROPERTY__FORMAT__CALLBACK => [
                        'isys_export_helper_nagios',
                        'notification_period'
                    ]
                ],
                C__PROPERTY__PROVIDES => [
                    C__PROPERTY__PROVIDES__SEARCH => false,
                    C__PROPERTY__PROVIDES__SEARCH_INDEX => false
                ]
            ]),
            'host_notification_period_plus'    => array_replace_recursive(isys_cmdb_dao_category_pattern::dialog_plus(), [
                C__PROPERTY__INFO => [
                    C__PROPERTY__INFO__TITLE       => 'host_notification_period+',
                    C__PROPERTY__INFO__DESCRIPTION => 'host_notification_period+'
                ],
                C__PROPERTY__DATA => [
                    C__PROPERTY__DATA__INDEX => false,
                    C__PROPERTY__DATA__FIELD        => 'isys_cats_person_nagios_list__host_notification_period_plus',
                    C__PROPERTY__DATA__SOURCE_TABLE => 'isys_nagios_timeperiods_plus',
                    C__PROPERTY__DATA__REFERENCES   => [
                        'isys_nagios_timeperiods_plus',
                        'isys_nagios_timeperiods_plus__id'
                    ],
                    C__PROPERTY__DATA__SELECT       => idoit\Module\Report\SqlQuery\Structure\SelectSubSelect::factory('SELECT isys_nagios_timeperiods_plus__title
                            FROM isys_cats_person_nagios_list
                            INNER JOIN isys_nagios_timeperiods_plus ON isys_nagios_timeperiods_plus__id = isys_cats_person_nagios_list__host_notification_period_plus',
                        'isys_cats_person_nagios_list', 'isys_cats_person_nagios_list__id', 'isys_cats_person_nagios_list__isys_obj__id'),
                    C__PROPERTY__DATA__JOIN         => [
                        idoit\Module\Report\SqlQuery\Structure\SelectJoin::factory('isys_cats_person_nagios_list', 'LEFT', 'isys_cats_person_nagios_list__isys_obj__id',
                            'isys_obj__id'),
                        idoit\Module\Report\SqlQuery\Structure\SelectJoin::factory('isys_nagios_timeperiods_plus', 'LEFT',
                            'isys_cats_person_nagios_list__host_notification_period_plus', 'isys_nagios_timeperiods_plus__id')
                    ]
                ],
                C__PROPERTY__UI   => [
                    C__PROPERTY__UI__ID     => 'CONTACT_HOST_NOTIFICATION_PERIOD_PLUS',
                    C__PROPERTY__UI__PARAMS => [
                        'p_strTable'        => 'isys_nagios_timeperiods_plus',
                        'disableInputGroup' => true,
                        'p_bInfoIconSpacer' => 0
                    ]
                ],
                C__PROPERTY__PROVIDES => [
                    C__PROPERTY__PROVIDES__SEARCH => false,
                    C__PROPERTY__PROVIDES__SEARCH_INDEX => false
                ]
            ]),
            'service_notification_period'      => array_replace_recursive(isys_cmdb_dao_category_pattern::dialog(), [
                C__PROPERTY__INFO   => [
                    C__PROPERTY__INFO__TITLE       => 'service_notification_period',
                    C__PROPERTY__INFO__DESCRIPTION => 'service_notification_period'
                ],
                C__PROPERTY__DATA   => [
                    C__PROPERTY__DATA__INDEX => false,
                    C__PROPERTY__DATA__SOURCE_TABLE => 'isys_nagios_timeperiods_plus',
                    C__PROPERTY__DATA__FIELD  => 'isys_cats_person_nagios_list__service_notification_period',
                    C__PROPERTY__DATA__SELECT => idoit\Module\Report\SqlQuery\Structure\SelectSubSelect::factory('SELECT isys_nagios_timeperiods__name
                            FROM isys_cats_person_nagios_list
                            INNER JOIN isys_nagios_timeperiods ON isys_nagios_timeperiods__id = isys_cats_person_nagios_list__service_notification_period',
                        'isys_cats_person_nagios_list', 'isys_cats_person_nagios_list__id', 'isys_cats_person_nagios_list__isys_obj__id'),
                    C__PROPERTY__DATA__JOIN   => [
                        idoit\Module\Report\SqlQuery\Structure\SelectJoin::factory('isys_cats_person_nagios_list', 'LEFT', 'isys_cats_person_nagios_list__isys_obj__id',
                            'isys_obj__id'),
                        idoit\Module\Report\SqlQuery\Structure\SelectJoin::factory('isys_nagios_timeperiods', 'LEFT',
                            'isys_cats_person_nagios_list__service_notification_period', 'isys_nagios_timeperiods__id')
                    ]
                ],
                C__PROPERTY__UI     => [
                    C__PROPERTY__UI__ID     => 'CONTACT_SERVICE_NOTIFICATION_PERIOD',
                    C__PROPERTY__UI__PARAMS => [
                        'p_arData'          => new isys_callback([
                            'isys_cmdb_dao_category_g_nagios',
                            'callback_property_general_dialog_nagios_methods'
                        ], ['getTimeperiodsAssoc']),
                        'disableInputGroup' => true,
                        'p_bInfoIconSpacer' => 0
                    ]
                ],
                C__PROPERTY__FORMAT => [
                    C__PROPERTY__FORMAT__CALLBACK => [
                        'isys_export_helper_nagios',
                        'notification_period'
                    ]
                ],
                C__PROPERTY__PROVIDES => [
                    C__PROPERTY__PROVIDES__SEARCH => false,
                    C__PROPERTY__PROVIDES__SEARCH_INDEX => false
                ]
            ]),
            'service_notification_period_plus' => array_replace_recursive(isys_cmdb_dao_category_pattern::dialog_plus(), [
                C__PROPERTY__INFO => [
                    C__PROPERTY__INFO__TITLE       => 'service_notification_period+',
                    C__PROPERTY__INFO__DESCRIPTION => 'service_notification_period+'
                ],
                C__PROPERTY__DATA => [
                    C__PROPERTY__DATA__INDEX => false,
                    C__PROPERTY__DATA__FIELD        => 'isys_cats_person_nagios_list__service_notification_period_plus',
                    C__PROPERTY__DATA__SOURCE_TABLE => 'isys_nagios_timeperiods_plus',
                    C__PROPERTY__DATA__REFERENCES   => [
                        'isys_nagios_timeperiods_plus',
                        'isys_nagios_timeperiods_plus__id'
                    ],
                    C__PROPERTY__DATA__SELECT       => idoit\Module\Report\SqlQuery\Structure\SelectSubSelect::factory('SELECT isys_nagios_timeperiods_plus__title
                            FROM isys_cats_person_nagios_list
                            INNER JOIN isys_nagios_timeperiods_plus ON isys_nagios_timeperiods_plus__id = isys_cats_person_nagios_list__service_notification_period_plus',
                        'isys_cats_person_nagios_list', 'isys_cats_person_nagios_list__id', 'isys_cats_person_nagios_list__isys_obj__id'),
                    C__PROPERTY__DATA__JOIN         => [
                        idoit\Module\Report\SqlQuery\Structure\SelectJoin::factory('isys_cats_person_nagios_list', 'LEFT', 'isys_cats_person_nagios_list__isys_obj__id',
                            'isys_obj__id'),
                        idoit\Module\Report\SqlQuery\Structure\SelectJoin::factory('isys_nagios_timeperiods_plus', 'LEFT',
                            'isys_cats_person_nagios_list__service_notification_period_plus', 'isys_nagios_timeperiods_plus__id')
                    ]
                ],
                C__PROPERTY__UI   => [
                    C__PROPERTY__UI__ID     => 'CONTACT_SERVICE_NOTIFICATION_PERIOD_PLUS',
                    C__PROPERTY__UI__PARAMS => [
                        'p_strTable'        => 'isys_nagios_timeperiods_plus',
                        'disableInputGroup' => true,
                        'p_bInfoIconSpacer' => 0
                    ]
                ],
                C__PROPERTY__PROVIDES => [
                    C__PROPERTY__PROVIDES__SEARCH => false,
                    C__PROPERTY__PROVIDES__SEARCH_INDEX => false
                ]
            ]),
            'host_notification_options'        => array_replace_recursive(isys_cmdb_dao_category_pattern::dialog(), [
                C__PROPERTY__INFO   => [
                    C__PROPERTY__INFO__TITLE       => 'host_notification_options',
                    C__PROPERTY__INFO__DESCRIPTION => 'host_notification_options'
                ],
                C__PROPERTY__DATA   => [
                    C__PROPERTY__DATA__TYPE   => C__TYPE__TEXT,
                    C__PROPERTY__DATA__FIELD  => 'isys_cats_person_nagios_list__host_notification_options',
                    C__PROPERTY__DATA__SELECT => idoit\Module\Report\SqlQuery\Structure\SelectSubSelect::factory('SELECT ' .
                        isys_cmdb_dao_category_g_nagios::build_nagios_dialog_list_selection(isys_component_dao_nagios::instance(isys_application::instance()->container->get('database'))
                            ->getHostNotificationOptionsAssoc(), 'isys_cats_person_nagios_list__host_notification_options') . ' FROM isys_cats_person_nagios_list',
                        'isys_cats_person_nagios_list', 'isys_cats_person_nagios_list__id', 'isys_cats_person_nagios_list__isys_obj__id', '', '',
                        idoit\Module\Report\SqlQuery\Structure\SelectCondition::factory([]),
                        idoit\Module\Report\SqlQuery\Structure\SelectGroupBy::factory(['isys_cats_person_nagios_list__id'])),
                    C__PROPERTY__DATA__JOIN   => [
                        idoit\Module\Report\SqlQuery\Structure\SelectJoin::factory('isys_cats_person_nagios_list', 'LEFT', 'isys_cats_person_nagios_list__isys_obj__id',
                            'isys_obj__id')
                    ]
                ],
                C__PROPERTY__UI     => [
                    C__PROPERTY__UI__ID => 'HOST_NOTIFICATION_OPTIONS',
                    C__PROPERTY__UI__PARAMS => [
                        'p_bDbFieldNN' => true,
                        'chosen' => true,
                        'p_multiple' => true,
                        'p_arData' => new isys_callback(['isys_component_dao_nagios', 'getHostNotificationOptionsAssoc'])
                    ]
                ],
                C__PROPERTY__FORMAT => [
                    C__PROPERTY__FORMAT__CALLBACK => [
                        'isys_export_helper_nagios',
                        'host_notification_options'
                    ]
                ],
                C__PROPERTY__PROVIDES => [
                    C__PROPERTY__PROVIDES__SEARCH_INDEX => false,
                    C__PROPERTY__PROVIDES__SEARCH => false
                ]
            ]),
            'service_notification_options'     => array_replace_recursive(isys_cmdb_dao_category_pattern::dialog(), [
                C__PROPERTY__INFO   => [
                    C__PROPERTY__INFO__TITLE       => 'service_notification_options',
                    C__PROPERTY__INFO__DESCRIPTION => 'service_notification_options'
                ],
                C__PROPERTY__DATA   => [
                    C__PROPERTY__DATA__TYPE   => C__TYPE__TEXT,
                    C__PROPERTY__DATA__FIELD  => 'isys_cats_person_nagios_list__service_notification_options',
                    C__PROPERTY__DATA__SELECT => idoit\Module\Report\SqlQuery\Structure\SelectSubSelect::factory('SELECT ' .
                        isys_cmdb_dao_category_g_nagios::build_nagios_dialog_list_selection(isys_component_dao_nagios::instance(isys_application::instance()->container->get('database'))
                            ->getServiceNotificationOptionsAssoc(), 'isys_cats_person_nagios_list__service_notification_options') . ' FROM isys_cats_person_nagios_list',
                        'isys_cats_person_nagios_list', 'isys_cats_person_nagios_list__id', 'isys_cats_person_nagios_list__isys_obj__id', '', '',
                        idoit\Module\Report\SqlQuery\Structure\SelectCondition::factory([]),
                        idoit\Module\Report\SqlQuery\Structure\SelectGroupBy::factory(['isys_cats_person_nagios_list__id'])),
                    C__PROPERTY__DATA__JOIN   => [
                        idoit\Module\Report\SqlQuery\Structure\SelectJoin::factory('isys_cats_person_nagios_list', 'LEFT', 'isys_cats_person_nagios_list__isys_obj__id',
                            'isys_obj__id')
                    ]
                ],
                C__PROPERTY__UI     => [
                    C__PROPERTY__UI__ID => 'SERVICE_NOTIFICATION_OPTIONS',
                    C__PROPERTY__UI__PARAMS => [
                        'p_bDbFieldNN' => true,
                        'chosen' => true,
                        'p_multiple' => true,
                        'p_arData' => new isys_callback(['isys_component_dao_nagios', 'getServiceNotificationOptionsAssoc'])
                    ]
                ],
                C__PROPERTY__FORMAT => [
                    C__PROPERTY__FORMAT__CALLBACK => [
                        'isys_export_helper_nagios',
                        'service_notification_options'
                    ]
                ],
                C__PROPERTY__PROVIDES => [
                    C__PROPERTY__PROVIDES__SEARCH_INDEX => false,
                    C__PROPERTY__PROVIDES__SEARCH => false
                ]
            ]),
            'host_notification_commands'       => array_replace_recursive(isys_cmdb_dao_category_pattern::dialog(), [
                C__PROPERTY__INFO   => [
                    C__PROPERTY__INFO__TITLE       => 'host_notification_commands',
                    C__PROPERTY__INFO__DESCRIPTION => 'host_notification_commands'
                ],
                C__PROPERTY__DATA   => [
                    C__PROPERTY__DATA__TYPE   => C__TYPE__TEXT,
                    C__PROPERTY__DATA__FIELD  => 'isys_cats_person_nagios_list__host_notification_commands',
                    C__PROPERTY__DATA__SELECT => idoit\Module\Report\SqlQuery\Structure\SelectSubSelect::factory('SELECT ' .
                        isys_cmdb_dao_category_g_nagios::build_nagios_dialog_list_selection(isys_component_dao_nagios::instance(isys_application::instance()->container->get('database'))
                            ->getCommandsAssoc(), 'isys_cats_person_nagios_list__host_notification_commands') . ' FROM isys_cats_person_nagios_list',
                        'isys_cats_person_nagios_list', 'isys_cats_person_nagios_list__id', 'isys_cats_person_nagios_list__isys_obj__id', '', '',
                        idoit\Module\Report\SqlQuery\Structure\SelectCondition::factory([]),
                        idoit\Module\Report\SqlQuery\Structure\SelectGroupBy::factory(['isys_cats_person_nagios_list__id'])),
                    C__PROPERTY__DATA__JOIN   => [
                        idoit\Module\Report\SqlQuery\Structure\SelectJoin::factory('isys_cats_person_nagios_list', 'LEFT', 'isys_cats_person_nagios_list__isys_obj__id',
                            'isys_obj__id')
                    ]
                ],
                C__PROPERTY__UI     => [
                    C__PROPERTY__UI__ID => 'CONTACT_HOST_NOTIFICATION_COMMANDS',
                    C__PROPERTY__UI__PARAMS => [
                        'p_bDbFieldNN' => true,
                        'chosen' => true,
                        'p_multiple' => true,
                        'p_arData' => new isys_callback(['isys_component_dao_nagios', 'getCommandsAssoc'])
                    ]
                ],
                C__PROPERTY__FORMAT => [
                    C__PROPERTY__FORMAT__CALLBACK => [
                        'isys_export_helper_nagios',
                        'host_notification_commands'
                    ]
                ],
                C__PROPERTY__PROVIDES => [
                    C__PROPERTY__PROVIDES__SEARCH_INDEX => false,
                    C__PROPERTY__PROVIDES__SEARCH => false
                ]
            ]),
            'service_notification_commands'    => array_replace_recursive(isys_cmdb_dao_category_pattern::dialog(), [
                C__PROPERTY__INFO   => [
                    C__PROPERTY__INFO__TITLE       => 'service_notification_commands',
                    C__PROPERTY__INFO__DESCRIPTION => 'service_notification_commands'
                ],
                C__PROPERTY__DATA   => [
                    C__PROPERTY__DATA__TYPE   => C__TYPE__TEXT,
                    C__PROPERTY__DATA__FIELD  => 'isys_cats_person_nagios_list__service_notification_commands',
                    C__PROPERTY__DATA__SELECT => idoit\Module\Report\SqlQuery\Structure\SelectSubSelect::factory('SELECT ' .
                        isys_cmdb_dao_category_g_nagios::build_nagios_dialog_list_selection(isys_component_dao_nagios::instance(isys_application::instance()->container->get('database'))
                            ->getCommandsAssoc(), 'isys_cats_person_nagios_list__service_notification_commands') . ' FROM isys_cats_person_nagios_list',
                        'isys_cats_person_nagios_list', 'isys_cats_person_nagios_list__id', 'isys_cats_person_nagios_list__isys_obj__id', '', '',
                        idoit\Module\Report\SqlQuery\Structure\SelectCondition::factory([]),
                        idoit\Module\Report\SqlQuery\Structure\SelectGroupBy::factory(['isys_cats_person_nagios_list__id'])),
                    C__PROPERTY__DATA__JOIN   => [
                        idoit\Module\Report\SqlQuery\Structure\SelectJoin::factory('isys_cats_person_nagios_list', 'LEFT', 'isys_cats_person_nagios_list__isys_obj__id',
                            'isys_obj__id')
                    ]
                ],
                C__PROPERTY__UI     => [
                    C__PROPERTY__UI__ID => 'CONTACT_SERVICE_NOTIFICATION_COMMANDS',
                    C__PROPERTY__UI__PARAMS => [
                        'p_bDbFieldNN' => true,
                        'chosen' => true,
                        'p_multiple' => true,
                        'p_arData' => new isys_callback(['isys_component_dao_nagios', 'getCommandsAssoc'])
                    ]
                ],
                C__PROPERTY__FORMAT => [
                    C__PROPERTY__FORMAT__CALLBACK => [
                        'isys_export_helper_nagios',
                        'service_notification_commands'
                    ]
                ],
                C__PROPERTY__PROVIDES => [
                    C__PROPERTY__PROVIDES__SEARCH_INDEX => false,
                    C__PROPERTY__PROVIDES__SEARCH => false
                ]
            ]),
            'can_submit_commands'              => array_replace_recursive(isys_cmdb_dao_category_pattern::dialog(), [
                C__PROPERTY__INFO     => [
                    C__PROPERTY__INFO__TITLE       => 'can_submit_commands',
                    C__PROPERTY__INFO__DESCRIPTION => 'can_submit_commands'
                ],
                C__PROPERTY__DATA     => [
                    C__PROPERTY__DATA__FIELD  => 'isys_cats_person_nagios_list__can_submit_commands',
                    C__PROPERTY__DATA__SELECT => idoit\Module\Report\SqlQuery\Structure\SelectSubSelect::factory('(CASE
                                    WHEN isys_cats_person_nagios_list__can_submit_commands = \'1\' THEN ' . $this->convert_sql_text('LC__UNIVERSAL__YES') . '
                                    WHEN isys_cats_person_nagios_list__can_submit_commands = \'0\' THEN ' . $this->convert_sql_text('LC__UNIVERSAL__NO') . '
                                    END)', 'isys_cats_person_nagios_list'),
                    C__PROPERTY__DATA__JOIN   => [
                        idoit\Module\Report\SqlQuery\Structure\SelectJoin::factory('isys_cats_person_nagios_list', 'LEFT', 'isys_cats_person_nagios_list__isys_obj__id',
                            'isys_obj__id')
                    ]
                ],
                C__PROPERTY__UI       => [
                    C__PROPERTY__UI__ID     => 'CONTACT_CAN_SUBMIT_COMMANDS',
                    C__PROPERTY__UI__PARAMS => [
                        'p_arData' => $l_dialog_yes_no
                    ]
                ],
                C__PROPERTY__PROVIDES => [
                    C__PROPERTY__PROVIDES__SEARCH => false,
                    C__PROPERTY__PROVIDES__SEARCH_INDEX => false,
                ],
                C__PROPERTY__FORMAT   => [
                    C__PROPERTY__FORMAT__CALLBACK => [
                        'isys_export_helper',
                        'get_yes_or_no'
                    ]
                ]
            ]),
            'retain_status_information'        => array_replace_recursive(isys_cmdb_dao_category_pattern::dialog(), [
                C__PROPERTY__INFO     => [
                    C__PROPERTY__INFO__TITLE       => 'retain_status_information',
                    C__PROPERTY__INFO__DESCRIPTION => 'retain_status_information'
                ],
                C__PROPERTY__DATA     => [
                    C__PROPERTY__DATA__FIELD  => 'isys_cats_person_nagios_list__retain_status_information',
                    C__PROPERTY__DATA__SELECT => idoit\Module\Report\SqlQuery\Structure\SelectSubSelect::factory('(CASE
                                    WHEN isys_cats_person_nagios_list__retain_status_information = \'1\' THEN ' . $this->convert_sql_text('LC__UNIVERSAL__YES') . '
                                    WHEN isys_cats_person_nagios_list__retain_status_information = \'0\' THEN ' . $this->convert_sql_text('LC__UNIVERSAL__NO') . '
                                    END)', 'isys_cats_person_nagios_list'),
                    C__PROPERTY__DATA__JOIN   => [
                        idoit\Module\Report\SqlQuery\Structure\SelectJoin::factory('isys_cats_person_nagios_list', 'LEFT', 'isys_cats_person_nagios_list__isys_obj__id',
                            'isys_obj__id')
                    ]
                ],
                C__PROPERTY__UI       => [
                    C__PROPERTY__UI__ID     => 'CONTACT_RETAIN_STATUS_INFORMATION',
                    C__PROPERTY__UI__PARAMS => [
                        'p_arData' => $l_dialog_yes_no
                    ]
                ],
                C__PROPERTY__PROVIDES => [
                    C__PROPERTY__PROVIDES__SEARCH => false,
                    C__PROPERTY__PROVIDES__SEARCH_INDEX => false
                ],
                C__PROPERTY__FORMAT   => [
                    C__PROPERTY__FORMAT__CALLBACK => [
                        'isys_export_helper',
                        'get_yes_or_no'
                    ]
                ]
            ]),
            'is_exportable'                    => array_replace_recursive(isys_cmdb_dao_category_pattern::dialog(), [
                C__PROPERTY__INFO     => [
                    C__PROPERTY__INFO__TITLE       => 'LC__CATG__NAGIOS_CONFIG_EXPORT',
                    C__PROPERTY__INFO__DESCRIPTION => 'Export this configuration'
                ],
                C__PROPERTY__DATA     => [
                    C__PROPERTY__DATA__FIELD  => 'isys_cats_person_nagios_list__is_exportable',
                    C__PROPERTY__DATA__SELECT => idoit\Module\Report\SqlQuery\Structure\SelectSubSelect::factory('(CASE
                                    WHEN isys_cats_person_nagios_list__is_exportable = \'1\' THEN ' . $this->convert_sql_text('LC__UNIVERSAL__YES') . '
                                    WHEN isys_cats_person_nagios_list__is_exportable = \'0\' THEN ' . $this->convert_sql_text('LC__UNIVERSAL__NO') . '
                                    END)', 'isys_cats_person_nagios_list'),
                    C__PROPERTY__DATA__JOIN   => [
                        idoit\Module\Report\SqlQuery\Structure\SelectJoin::factory('isys_cats_person_nagios_list', 'LEFT', 'isys_cats_person_nagios_list__isys_obj__id',
                            'isys_obj__id')
                    ]
                ],
                C__PROPERTY__UI       => [
                    C__PROPERTY__UI__ID     => 'CONTACT_NAGIOS_IS_EXPORTABLE',
                    C__PROPERTY__UI__PARAMS => [
                        'p_arData' => $l_dialog_yes_no
                    ]
                ],
                C__PROPERTY__PROVIDES => [
                    C__PROPERTY__PROVIDES__SEARCH    => false,
                    C__PROPERTY__PROVIDES__SEARCH_INDEX    => false,
                    C__PROPERTY__PROVIDES__IMPORT    => true,
                    C__PROPERTY__PROVIDES__EXPORT    => true,
                    C__PROPERTY__PROVIDES__MULTIEDIT => false
                ],
                C__PROPERTY__FORMAT   => [
                    C__PROPERTY__FORMAT__CALLBACK => [
                        'isys_export_helper',
                        'get_yes_or_no'
                    ]
                ]
            ]),
            'retain_nonstatus_information'     => array_replace_recursive(isys_cmdb_dao_category_pattern::dialog(), [
                C__PROPERTY__INFO     => [
                    C__PROPERTY__INFO__TITLE       => 'retain_nonstatus_information',
                    C__PROPERTY__INFO__DESCRIPTION => 'retain_nonstatus_information'
                ],
                C__PROPERTY__DATA     => [
                    C__PROPERTY__DATA__FIELD  => 'isys_cats_person_nagios_list__retain_nonstatus_information',
                    C__PROPERTY__DATA__SELECT => idoit\Module\Report\SqlQuery\Structure\SelectSubSelect::factory('(CASE
                                    WHEN isys_cats_person_nagios_list__retain_nonstatus_information = \'1\' THEN ' . $this->convert_sql_text('LC__UNIVERSAL__YES') . '
                                    WHEN isys_cats_person_nagios_list__retain_nonstatus_information = \'0\' THEN ' . $this->convert_sql_text('LC__UNIVERSAL__NO') . '
                                    END)', 'isys_cats_person_nagios_list'),
                    C__PROPERTY__DATA__JOIN   => [
                        idoit\Module\Report\SqlQuery\Structure\SelectJoin::factory('isys_cats_person_nagios_list', 'LEFT', 'isys_cats_person_nagios_list__isys_obj__id',
                            'isys_obj__id')
                    ]
                ],
                C__PROPERTY__UI       => [
                    C__PROPERTY__UI__ID     => 'CONTACT_RETAIN_NONSTATUS_INFORMATION',
                    C__PROPERTY__UI__PARAMS => [
                        'p_arData' => $l_dialog_yes_no
                    ]
                ],
                C__PROPERTY__PROVIDES => [
                    C__PROPERTY__PROVIDES__SEARCH => false,
                    C__PROPERTY__PROVIDES__SEARCH_INDEX    => false,
                ],
                C__PROPERTY__FORMAT   => [
                    C__PROPERTY__FORMAT__CALLBACK => [
                        'isys_export_helper',
                        'get_yes_or_no'
                    ]
                ]
            ]),
            'custom_object_vars'               => array_replace_recursive(isys_cmdb_dao_category_pattern::textarea(), [
                C__PROPERTY__INFO  => [
                    C__PROPERTY__INFO__TITLE       => 'custom_object_vars',
                    C__PROPERTY__INFO__DESCRIPTION => 'custom_object_vars'
                ],
                C__PROPERTY__DATA  => [
                    C__PROPERTY__DATA__FIELD => 'isys_cats_person_nagios_list__custom_obj_vars'
                ],
                C__PROPERTY__UI    => [
                    C__PROPERTY__UI__ID => 'C__CATS__PERSON_NAGIOS__CUSTOM_OBJ_VARS'
                ],
                C__PROPERTY__CHECK => [
                    C__PROPERTY__CHECK__SANITIZATION => null
                ],
                C__PROPERTY__PROVIDES => [
                    C__PROPERTY__PROVIDES__SEARCH => false,
                    C__PROPERTY__PROVIDES__SEARCH_INDEX    => false,
                ]
            ]),
            'description'                      => array_replace_recursive(isys_cmdb_dao_category_pattern::commentary(), [
                C__PROPERTY__INFO => [
                    C__PROPERTY__INFO__TITLE       => 'LC__CMDB__LOGBOOK__DESCRIPTION',
                    C__PROPERTY__INFO__DESCRIPTION => 'Description'
                ],
                C__PROPERTY__DATA => [
                    C__PROPERTY__DATA__FIELD => 'isys_cats_person_nagios_list__description'
                ],
                C__PROPERTY__UI   => [
                    C__PROPERTY__UI__ID => 'C__CMDB__CAT__COMMENTARY_' . C__CMDB__CATEGORY__TYPE_SPECIFIC . C__CATS__PERSON_NAGIOS
                ]
            ])
        ];
    }

    /**
     * @param array $data
     *
     * @return bool|mixed
     */
    public function create_data($data)
    {
        // @see NAGIOS-34 Combine array data to a comma-separated list.
        if (is_array($data['host_notification_options'])) {
            $data['host_notification_options'] = implode(',', $data['host_notification_options']);
        }

        if (is_array($data['service_notification_options'])) {
            $data['service_notification_options'] = implode(',', $data['service_notification_options']);
        }

        if (is_array($data['host_notification_commands'])) {
            $data['host_notification_commands'] = implode(',', $data['host_notification_commands']);
        }

        if (is_array($data['service_notification_commands'])) {
            $data['service_notification_commands'] = implode(',', $data['service_notification_commands']);
        }

        return parent::create_data($data);
    }

    /**
     * @param int $categoryDataId
     * @param array $data
     *
     * @return bool
     * @throws isys_exception_dao
     * @throws isys_exception_dao_cmdb
     */
    public function save_data($categoryDataId, $data)
    {
        // @see NAGIOS-34 Combine array data to a comma-separated list.
        if (is_array($data['host_notification_options'])) {
            $data['host_notification_options'] = implode(',', $data['host_notification_options']);
        }

        if (is_array($data['service_notification_options'])) {
            $data['service_notification_options'] = implode(',', $data['service_notification_options']);
        }

        if (is_array($data['host_notification_commands'])) {
            $data['host_notification_commands'] = implode(',', $data['host_notification_commands']);
        }

        if (is_array($data['service_notification_commands'])) {
            $data['service_notification_commands'] = implode(',', $data['service_notification_commands']);
        }

        return parent::save_data($categoryDataId, $data);
    }
}
